/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnEditFileProvider
implements EditFileProvider {
    private final SvnVcs myVCS;

    public SvnEditFileProvider(SvnVcs vcs) {
        this.myVCS = vcs;
    }

    public void editFiles(VirtualFile[] files) throws VcsException {
        File[] ioFiles = new File[files.length];
        SVNWCClient client = this.myVCS.createWCClient();
        for (int i = 0; i < files.length; ++i) {
            ioFiles[i] = new File(files[i].getPath());
            try {
                SVNPropertyData property = client.doGetProperty(ioFiles[i], "svn:needs-lock", SVNRevision.WORKING, SVNRevision.WORKING);
                if (property != null && property.getValue() != null) continue;
                throw new VcsException(SvnBundle.message("exception.text.file.miss.svn", ioFiles[i].getName()));
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
        }
        SvnUtil.doLockFiles(this.myVCS.getProject(), this.myVCS, ioFiles);
    }

    public String getRequestText() {
        return SvnBundle.message("confirmation.text.edit.file", new Object[0]);
    }
}

