/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestsMerger {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.RequestsMerger");
    private static final int ourDelay = 300;
    private final MyWorker myWorker;
    private final Object myLock = new Object();
    private MyState myState;
    private final Consumer<Runnable> myAlarm;
    private final List<Runnable> myWaitingStartListeners;
    private final List<Runnable> myWaitingFinishListeners;

    public RequestsMerger(Runnable runnable, Consumer<Runnable> alarm) {
        this.myAlarm = alarm;
        this.myWorker = new MyWorker(runnable);
        this.myState = MyState.empty;
        this.myWaitingStartListeners = new ArrayList<Runnable>();
        this.myWaitingFinishListeners = new ArrayList<Runnable>();
    }

    public void request() {
        LOG.debug("ext: request");
        this.doAction(MyAction.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRefresh(Runnable runnable) {
        LOG.debug("ext: wait refresh");
        Object object = this.myLock;
        synchronized (object) {
            this.myWaitingStartListeners.add(runnable);
        }
        this.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialization(Runnable runnable) {
        LOG.debug("ext: ensure init");
        Object object = this.myLock;
        synchronized (object) {
            if (this.myWorker.isInitialized()) {
                runnable.run();
                return;
            }
            this.myWaitingStartListeners.add(runnable);
        }
        this.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(MyAction action) {
        MyExitAction[] exitActions;
        LOG.debug("doAction: START " + action.name());
        ArrayList<Runnable> toBeCalled = null;
        Object object = this.myLock;
        synchronized (object) {
            MyState oldState = this.myState;
            this.myState = this.myState.transition(action);
            if (oldState.equals((Object)this.myState)) {
                return;
            }
            exitActions = MyTransitionAction.getExit(oldState, this.myState);
            LOG.debug("doAction: oldState: " + oldState.name() + ", newState: " + this.myState.name());
            if (LOG.isDebugEnabled() && exitActions != null) {
                String debugExitActions = StringUtil.join((Object[])exitActions, (Function)new Function<MyExitAction, String>(){

                    public String fun(MyExitAction exitAction) {
                        return exitAction.name();
                    }
                }, (String)" ");
                LOG.debug("exit actions: " + debugExitActions);
            }
            if (exitActions != null) {
                for (MyExitAction exitAction : exitActions) {
                    if (MyExitAction.markStart.equals((Object)exitAction)) {
                        this.myWaitingFinishListeners.addAll(this.myWaitingStartListeners);
                        this.myWaitingStartListeners.clear();
                        continue;
                    }
                    if (!MyExitAction.markEnd.equals((Object)exitAction)) continue;
                    toBeCalled = new ArrayList<Runnable>(this.myWaitingFinishListeners);
                    this.myWaitingFinishListeners.clear();
                }
            }
        }
        if (exitActions != null) {
            for (MyExitAction exitAction : exitActions) {
                if (!MyExitAction.submitRequestToExecutor.equals((Object)exitAction)) continue;
                this.myAlarm.consume((Object)this.myWorker);
            }
        }
        if (toBeCalled != null) {
            for (Runnable runnable : toBeCalled) {
                runnable.run();
            }
        }
        LOG.debug("doAction: END " + action.name());
    }

    private static enum MyAction {
        request,
        start,
        finish;

    }

    private static enum MyExitAction {
        empty,
        submitRequestToExecutor,
        markStart,
        markEnd;

    }

    private static class MyTransitionAction {
        private static final Map<Pair<MyState, MyState>, MyExitAction[]> myMap = new HashMap<Pair<MyState, MyState>, MyExitAction[]>();

        private MyTransitionAction() {
        }

        private static void add(MyState from, MyState to, MyExitAction ... action) {
            myMap.put((Pair<MyState, MyState>)new Pair((Object)from, (Object)to), action);
        }

        @Nullable
        public static MyExitAction[] getExit(MyState from, MyState to) {
            return myMap.get(new Pair((Object)from, (Object)to));
        }

        static {
            MyTransitionAction.add(MyState.empty, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor);
            MyTransitionAction.add(MyState.requestSubmitted, MyState.inProgress, MyExitAction.markStart);
            MyTransitionAction.add(MyState.inProgress, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgress, MyState.requestSubmitted, MyExitAction.markEnd);
        }
    }

    private static enum MyState {
        empty{

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public MyState transition(MyAction action) {
                MyState myState;
                if (MyAction.request.equals((Object)action)) {
                    myState = requestSubmitted;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$1.transition must not return null");
                    return myState;
                }
                MyState.logWrongAction((MyState)this, action);
                myState = this;
                if (myState != null) return myState;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$1.transition must not return null");
            }
        }
        ,
        inProgress{

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public MyState transition(MyAction action) {
                MyState myState;
                if (MyAction.finish.equals((Object)action)) {
                    myState = empty;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$2.transition must not return null");
                    return myState;
                }
                if (MyAction.request.equals((Object)action)) {
                    myState = inProgressRequestSubmitted;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$2.transition must not return null");
                    return myState;
                }
                MyState.logWrongAction((MyState)this, action);
                myState = this;
                if (myState != null) return myState;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$2.transition must not return null");
            }
        }
        ,
        inProgressRequestSubmitted{

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public MyState transition(MyAction action) {
                MyState myState;
                if (MyAction.finish.equals((Object)action)) {
                    myState = requestSubmitted;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$3.transition must not return null");
                    return myState;
                }
                if (MyAction.start.equals((Object)action)) {
                    MyState.logWrongAction((MyState)this, action);
                }
                if ((myState = this) != null) return myState;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$3.transition must not return null");
            }
        }
        ,
        requestSubmitted{

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public MyState transition(MyAction action) {
                MyState myState;
                if (MyAction.start.equals((Object)action)) {
                    myState = inProgress;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$4.transition must not return null");
                    return myState;
                }
                if (MyAction.finish.equals((Object)action)) {
                    MyState.logWrongAction((MyState)this, action);
                    myState = empty;
                    if (myState == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$4.transition must not return null");
                    return myState;
                }
                myState = this;
                if (myState != null) return myState;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/RequestsMerger$MyState$4.transition must not return null");
            }
        };


        @NotNull
        public abstract MyState transition(MyAction var1);

        private static void logWrongAction(MyState state, MyAction action) {
            LOG.info("Wrong action: state=" + state.name() + ", action=" + action.name());
        }
    }

    private class MyWorker
    implements Runnable {
        private boolean myInitialized;
        private final Runnable myRunnable;

        private MyWorker(Runnable runnable) {
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("worker: started refresh");
            try {
                RequestsMerger.this.doAction(MyAction.start);
                this.myRunnable.run();
                Object object = RequestsMerger.this.myLock;
                synchronized (object) {
                    this.myInitialized = true;
                }
            }
            finally {
                RequestsMerger.this.doAction(MyAction.finish);
            }
        }

        public boolean isInitialized() {
            return this.myInitialized;
        }
    }
}

