/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.openapi.util.io.FileUtil;
import com.trilead.ssh2.KnownHosts;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitSSHHandler;
import org.jetbrains.git4idea.ssh.SSHMain;
import org.jetbrains.git4idea.ssh.SSHMainBundle;
import org.jetbrains.git4idea.util.ScriptGenerator;

public abstract class GitSSHService {
    private static final Random RANDOM = new Random();
    private boolean myInitialized = false;
    private File myScriptPath;
    private final THashMap<Integer, Handler> handlers = new THashMap();

    public abstract int getXmlRcpPort();

    @NotNull
    public synchronized File getScriptPath() throws IOException {
        if (this.myScriptPath == null || !this.myScriptPath.exists()) {
            ScriptGenerator generator = new ScriptGenerator("git-ssh-", SSHMain.class, this.getTempDir());
            generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
            generator.addClasses(KnownHosts.class, FileUtil.class);
            generator.addResource(SSHMainBundle.class, "/org/jetbrains/git4idea/ssh/SSHMainBundle.properties");
            this.myScriptPath = generator.generate();
        }
        File file = this.myScriptPath;
        if (file == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/git4idea/ssh/GitSSHService.getScriptPath must not return null");
        }
        return file;
    }

    @Nullable
    protected File getTempDir() {
        return null;
    }

    public void initComponent() {
        if (!this.myInitialized) {
            this.registerInternalHandler("Git4ideaSSHHandler", new InternalRequestHandler());
            this.myInitialized = true;
        }
    }

    protected abstract void registerInternalHandler(String var1, GitSSHHandler var2);

    public synchronized int registerHandler(@NotNull Handler handler) {
        int candidate;
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/git4idea/ssh/GitSSHService.registerHandler must not be null");
        }
        this.initComponent();
        while ((candidate = RANDOM.nextInt()) == Integer.MIN_VALUE || this.handlers.containsKey((Object)(candidate = Math.abs(candidate)))) {
        }
        this.handlers.put((Object)candidate, (Object)handler);
        return candidate;
    }

    @NotNull
    private synchronized Handler getHandler(int key) {
        Handler rc = (Handler)this.handlers.get((Object)key);
        if (rc == null) {
            throw new IllegalStateException("No handler for the key " + key);
        }
        Handler handler = rc;
        if (handler == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/git4idea/ssh/GitSSHService.getHandler must not return null");
        }
        return handler;
    }

    public synchronized void unregisterHandler(int key) {
        if (this.handlers.remove((Object)key) == null) {
            throw new IllegalArgumentException("The handler " + key + " is not registered");
        }
    }

    public class InternalRequestHandler
    implements GitSSHHandler {
        @Override
        public boolean verifyServerHostKey(int handler, String hostname, int port, String serverHostKeyAlgorithm, String serverHostKey, boolean isNew) {
            return GitSSHService.this.getHandler(handler).verifyServerHostKey(hostname, port, serverHostKeyAlgorithm, serverHostKey, isNew);
        }

        @Override
        public String askPassphrase(int handler, String username, String keyPath, boolean resetPassword, String lastError) {
            return this.adjustNull(GitSSHService.this.getHandler(handler).askPassphrase(username, keyPath, resetPassword, lastError));
        }

        @Override
        public Vector<String> replyToChallenge(int handlerNo, String username, String name, String instruction, int numPrompts, Vector<String> prompt, Vector<Boolean> echo, String lastError) {
            return this.adjustNull(GitSSHService.this.getHandler(handlerNo).replyToChallenge(username, name, instruction, numPrompts, prompt, echo, lastError));
        }

        @Override
        public String askPassword(int handlerNo, String username, boolean resetPassword, String lastError) {
            return this.adjustNull(GitSSHService.this.getHandler(handlerNo).askPassword(username, resetPassword, lastError));
        }

        private String adjustNull(String s) {
            return s == null ? "-" : "+" + s;
        }

        private <T> Vector<T> adjustNull(Vector<T> s) {
            return s == null ? new Vector() : s;
        }
    }

    public static interface Handler {
        public boolean verifyServerHostKey(String var1, int var2, String var3, String var4, boolean var5);

        public String askPassphrase(String var1, String var2, boolean var3, String var4);

        public Vector<String> replyToChallenge(String var1, String var2, String var3, int var4, Vector<String> var5, Vector<Boolean> var6, String var7);

        public String askPassword(String var1, boolean var2, String var3);
    }
}

