/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitRefspecPanel;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GitFetchDialog
extends DialogWrapper {
    private JComboBox myGitRoot;
    private GitRefspecPanel myRefspecs;
    private JComboBox myFetchTagsComboBox;
    private JCheckBox myForceReferencesUpdateCheckBox;
    private JComboBox myRemote;
    private JPanel myPanel;
    private final Project myProject;
    private static final String TAGS_POLICY_FOR_FETCHED_COMMITS = GitBundle.getString("fetch.tags.policy.for.fetched.commits");
    private static final String TAGS_POLICY_ALL = GitBundle.getString("fetch.tags.policy.all");
    private static final String TAGS_POLICY_NONE = GitBundle.getString("fetch.tags.policy.none");

    public GitFetchDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("fetch.title"));
        this.setOKButtonText(GitBundle.getString("fetch.button"));
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRoot, null);
        this.myProject = project;
        this.myRefspecs.setProject(project);
        this.myRefspecs.setReferenceSource(GitRefspecPanel.ReferenceSource.FETCH);
        this.setupRemotes();
        this.setupFetchTagsPolicy();
        this.init();
        this.setupValidation();
    }

    private void setupValidation() {
        final JTextField remoteTextField = this.getRemoteTextField();
        final DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (remoteTextField.getText().length() == 0) {
                    GitFetchDialog.this.setOKActionEnabled(false);
                    GitFetchDialog.this.setErrorText(null);
                    return;
                }
                String result = GitFetchDialog.this.myRefspecs.validateFields();
                if (result != null) {
                    GitFetchDialog.this.setOKActionEnabled(false);
                    GitFetchDialog.this.setErrorText(result.length() == 0 ? null : result);
                    return;
                }
                GitFetchDialog.this.setOKActionEnabled(true);
                GitFetchDialog.this.setErrorText(null);
            }
        };
        remoteTextField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myRefspecs.addValidationRequiredListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.changedUpdate(null);
            }
        });
        listener.changedUpdate(null);
    }

    private void setupFetchTagsPolicy() {
        this.myFetchTagsComboBox.addItem(TAGS_POLICY_FOR_FETCHED_COMMITS);
        this.myFetchTagsComboBox.addItem(TAGS_POLICY_ALL);
        this.myFetchTagsComboBox.addItem(TAGS_POLICY_NONE);
        this.myFetchTagsComboBox.setSelectedIndex(0);
    }

    private void setupRemotes() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitFetchDialog.this.myRefspecs.setGitRoot(GitFetchDialog.this.getGitRoot());
                GitFetchDialog.this.updateRemotes();
            }
        };
        this.myGitRoot.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        final JTextField textField = this.getRemoteTextField();
        DocumentAdapter remoteListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitFetchDialog.this.myRefspecs.setRemote(textField.getText());
            }
        };
        textField.getDocument().addDocumentListener((DocumentListener)remoteListener);
        remoteListener.changedUpdate(null);
    }

    private JTextField getRemoteTextField() {
        return (JTextField)this.myRemote.getEditor().getEditorComponent();
    }

    private void updateRemotes() {
        GitUIUtil.setupRemotes(this.myProject, this.getGitRoot(), this.myRemote, true);
    }

    protected VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public GitLineHandler fetchHandler() {
        String tagsPolicy;
        GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.FETCH);
        h.addParameters("-v");
        if (this.myForceReferencesUpdateCheckBox.isSelected()) {
            h.addParameters("--force");
        }
        if (TAGS_POLICY_ALL.equals(tagsPolicy = (String)this.myFetchTagsComboBox.getSelectedItem())) {
            h.addParameters("--tags");
        } else if (TAGS_POLICY_NONE.equals(tagsPolicy)) {
            h.addParameters("--no-tags");
        }
        h.addParameters(this.getRemote());
        h.addParameters(this.myRefspecs.getReferences());
        return h;
    }

    public String getRemote() {
        return this.getRemoteTextField().getText();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Fetch";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        GitRefspecPanel gitRefspecPanel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.remote.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.tags.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRefspecs = gitRefspecPanel = new GitRefspecPanel();
        JComponent jComponent = gitRefspecPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(4, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myGitRoot = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myRemote = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.remote.tooltip"));
        jComboBox2.setEditable(true);
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFetchTagsComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.tags.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myForceReferencesUpdateCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.force.references.update"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fetch.force.references.update.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

