/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitRemote;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CurrentBranchDialog
extends DialogWrapper {
    private static final String REMOTE_THIS = GitBundle.getString("current.branch.tracked.remote.this");
    private static final String REMOTE_NONE = GitBundle.getString("current.branch.tracked.remote.none");
    private static final String BRANCH_NONE = GitBundle.getString("current.branch.tracked.branch.none");
    private JPanel myPanel;
    private JComboBox myGitRoot;
    private JLabel myCurrentBranch;
    private JComboBox myRepositoryComboBox;
    private JComboBox myBranchComboBox;
    private List<GitBranch> myBranches;
    private String myTrackedRepository;
    private String myTrackedBranch;
    private Project myProject;

    public CurrentBranchDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) throws VcsException {
        super(project, true);
        this.$$$setupUI$$$();
        this.myBranches = new LinkedList<GitBranch>();
        this.myProject = project;
        this.setTitle(GitBundle.getString("current.branch.title"));
        this.setOKButtonText(GitBundle.getString("current.branch.change.tracked"));
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRoot, this.myCurrentBranch);
        this.myGitRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CurrentBranchDialog.this.rootUpdated();
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(CurrentBranchDialog.this.myProject, ex, "git config");
                }
            }
        });
        this.myRepositoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentBranchDialog.this.trackedRemoteUpdated();
            }
        });
        this.myBranchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentBranchDialog.this.validateFields();
            }
        });
        this.rootUpdated();
        this.init();
    }

    private void rootUpdated() throws VcsException {
        VirtualFile root = this.getRoot();
        GitBranch current = GitBranch.current(this.myProject, root);
        this.myRepositoryComboBox.removeAllItems();
        this.myRepositoryComboBox.addItem(REMOTE_NONE);
        if (current != null) {
            this.myRepositoryComboBox.addItem(REMOTE_THIS);
            for (GitRemote r : GitRemote.list(this.myProject, root)) {
                this.myRepositoryComboBox.addItem(r.name());
            }
        }
        String string = this.myTrackedRepository = current == null ? null : current.getTrackedRemoteName(this.myProject, root);
        if (this.myTrackedRepository == null) {
            this.myTrackedRepository = REMOTE_NONE;
        } else if (".".equals(this.myTrackedRepository)) {
            this.myTrackedRepository = REMOTE_THIS;
        }
        String string2 = this.myTrackedBranch = current == null ? null : current.getTrackedBranchName(this.myProject, root);
        if (this.myTrackedBranch == null) {
            this.myTrackedBranch = BRANCH_NONE;
        } else if (this.myTrackedBranch.startsWith("refs/heads/")) {
            this.myTrackedBranch = this.myTrackedBranch.substring("refs/heads/".length());
        }
        this.myRepositoryComboBox.setSelectedItem(this.myTrackedRepository);
        this.myBranches.clear();
        GitBranch.list(this.myProject, root, true, true, this.myBranches);
        this.trackedRemoteUpdated();
    }

    private void trackedRemoteUpdated() {
        String remote = this.getTrackedRemote();
        this.myBranchComboBox.removeAllItems();
        if (REMOTE_NONE.equals(remote)) {
            this.myBranchComboBox.addItem(BRANCH_NONE);
            this.myBranchComboBox.setSelectedItem(BRANCH_NONE);
        } else {
            if (REMOTE_THIS.equals(remote)) {
                for (GitBranch b : this.myBranches) {
                    if (b.isRemote()) continue;
                    this.myBranchComboBox.addItem(b.getName());
                }
            } else {
                String prefix = "refs/remotes/" + remote + "/";
                for (GitBranch b : this.myBranches) {
                    String name;
                    if (!b.isRemote() || !(name = b.getFullName()).startsWith(prefix)) continue;
                    this.myBranchComboBox.addItem(b.getFullName().substring(prefix.length()));
                }
            }
            if (this.myTrackedBranch != null) {
                this.myBranchComboBox.setSelectedItem(this.myTrackedBranch);
            }
        }
        this.validateFields();
    }

    public void updateTrackedBranch() throws VcsException {
        String remote = this.getTrackedRemote();
        String branch = this.getTrackedBranch();
        if (remote.equals(REMOTE_NONE) || branch.equals(REMOTE_NONE)) {
            remote = null;
            branch = null;
        } else if (remote.equals(REMOTE_THIS)) {
            remote = ".";
        }
        GitBranch c = GitBranch.current(this.myProject, this.getRoot());
        if (c != null) {
            c.setTrackedBranch(this.myProject, this.getRoot(), remote, "refs/heads/" + branch);
        }
    }

    private String getTrackedRemote() {
        String remote = (String)this.myRepositoryComboBox.getSelectedItem();
        return remote == null ? REMOTE_NONE : remote;
    }

    private void validateFields() {
        if (this.getTrackedRemote().equals(this.myTrackedRepository) && this.getTrackedBranch().equals(this.myTrackedBranch)) {
            this.setOKActionEnabled(false);
        } else {
            this.setOKActionEnabled(true);
        }
    }

    private String getTrackedBranch() {
        String branch = (String)this.myBranchComboBox.getSelectedItem();
        return branch == null ? BRANCH_NONE : branch;
    }

    private VirtualFile getRoot() {
        return GitUIUtil.getRootFromRootChooser(this.myGitRoot);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getHelpId() {
        return "reference.vcs.git.current.branch";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGitRoot = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("current.branch.tracked.repository"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("current.branch.tracked.repository.tooltip"));
        jPanel.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("current.branch.tracked.branch"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("current.branch.tracked.branch.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("current.branch.tracked.title"));
        jPanel.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

