/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashMap;
import git4idea.GitBranch;
import git4idea.GitRemote;
import git4idea.GitTag;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class GitPushDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)GitPushDialog.class.getName());
    private static final String PUSH_POLICY_SELECTED = GitBundle.getString("push.policy.selected");
    private static final String PUSH_POLICY_DEFAULT = GitBundle.getString("push.policy.default");
    private static final String PUSH_POLICY_ALL = GitBundle.getString("push.policy.all");
    private static final String PUSH_POLICY_MIRROR = GitBundle.getString("push.policy.mirror");
    private JPanel myPanel;
    private JComboBox myGitRootComboBox;
    private JComboBox myRemoteComboBox;
    private JCheckBox myPushTagsCheckBox;
    private JCheckBox myUseThinPackCheckBox;
    private JComboBox myPushPolicy;
    private JCheckBox myForceUpdateCheckBox;
    private ElementsChooser<String> myBranchChooser;
    private JLabel myCurrentBranch;
    private JCheckBox myShowTagsCheckBox;
    private final ArrayList<String> myBranchNames;
    private final ArrayList<String> myTagNames;
    private final HashMap<String, Boolean> myMirrorChecks;
    private final Project myProject;

    public GitPushDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myBranchNames = new ArrayList();
        this.myTagNames = new ArrayList();
        this.myMirrorChecks = new HashMap();
        this.setTitle(GitBundle.getString("push.title"));
        this.setOKButtonText(GitBundle.getString("push.button"));
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myProject = project;
        this.setupRemotes();
        this.setupPolicy();
        this.setupValidation();
        this.myShowTagsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GitPushDialog.this.myPushPolicy.getSelectedItem().equals(PUSH_POLICY_SELECTED)) {
                    GitPushDialog.this.updateBranchChooser();
                }
            }
        });
        this.init();
    }

    public GitLineHandler handler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.PUSH);
        String policy = (String)this.myPushPolicy.getSelectedItem();
        if (PUSH_POLICY_ALL.equals(policy)) {
            h.addParameters("--all");
        } else if (PUSH_POLICY_MIRROR.equals(policy)) {
            h.addParameters("--mirror");
        }
        if (this.myPushTagsCheckBox.isEnabled() && this.myPushTagsCheckBox.isSelected()) {
            h.addParameters("--tags");
        }
        if (this.myUseThinPackCheckBox.isSelected()) {
            h.addParameters("--thin");
        }
        if (this.myForceUpdateCheckBox.isSelected()) {
            h.addParameters("--force");
        }
        h.addParameters("-v");
        h.addParameters(this.getRemoteTextField().getText());
        if (PUSH_POLICY_SELECTED.equals(policy)) {
            for (String b : this.myBranchChooser.getMarkedElements()) {
                if (this.myBranchNames.contains(b)) {
                    h.addParameters(b);
                    continue;
                }
                h.addParameters("tag", b);
            }
        }
        return h;
    }

    private void setupValidation() {
        this.myPushPolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPushDialog.this.validateFields();
            }
        });
        this.getRemoteTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitPushDialog.this.validateFields();
            }
        });
        this.myBranchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                GitPushDialog.this.validateFields();
            }
        });
        this.validateFields();
    }

    private void validateFields() {
        boolean isValid = this.getRemoteTextField().getText().length() != 0;
        Object policy = this.myPushPolicy.getSelectedItem();
        this.setOKActionEnabled(isValid &= !policy.equals(PUSH_POLICY_SELECTED) || this.myBranchChooser.getMarkedElements().size() != 0);
    }

    private void setupPolicy() {
        this.myPushPolicy.addItem(PUSH_POLICY_SELECTED);
        this.myPushPolicy.addItem(PUSH_POLICY_DEFAULT);
        this.myPushPolicy.addItem(PUSH_POLICY_ALL);
        this.myPushPolicy.addItem(PUSH_POLICY_MIRROR);
        this.myPushPolicy.setSelectedIndex(0);
        ActionListener policyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String p = (String)GitPushDialog.this.myPushPolicy.getSelectedItem();
                if (PUSH_POLICY_SELECTED.equals(p)) {
                    GitPushDialog.this.myBranchChooser.setEnabled(true);
                    GitPushDialog.this.myShowTagsCheckBox.setEnabled(true);
                    GitPushDialog.this.updateBranchChooser();
                } else {
                    GitPushDialog.this.myBranchChooser.clear();
                    GitPushDialog.this.myBranchChooser.setEnabled(false);
                    GitPushDialog.this.myShowTagsCheckBox.setEnabled(false);
                }
                if (PUSH_POLICY_MIRROR.equals(p)) {
                    GitPushDialog.this.myPushTagsCheckBox.setEnabled(false);
                    GitPushDialog.this.myPushTagsCheckBox.setSelected(true);
                    GitPushDialog.this.myForceUpdateCheckBox.setEnabled(false);
                    GitPushDialog.this.myForceUpdateCheckBox.setSelected(true);
                } else {
                    if (!GitPushDialog.this.myForceUpdateCheckBox.isEnabled()) {
                        GitPushDialog.this.myForceUpdateCheckBox.setEnabled(true);
                        GitPushDialog.this.myForceUpdateCheckBox.setSelected(false);
                    }
                    if (PUSH_POLICY_ALL.equals(p)) {
                        GitPushDialog.this.myPushTagsCheckBox.setEnabled(false);
                        GitPushDialog.this.myPushTagsCheckBox.setSelected(false);
                    } else if (!GitPushDialog.this.myPushTagsCheckBox.isEnabled()) {
                        GitPushDialog.this.myPushTagsCheckBox.setEnabled(true);
                        GitPushDialog.this.myPushTagsCheckBox.setSelected(false);
                    }
                }
            }
        };
        this.myPushPolicy.addActionListener(policyListener);
        policyListener.actionPerformed(null);
        final DocumentAdapter listener = new DocumentAdapter(){
            VirtualFile myPreviousRoot;
            GitRemote myPreviousRemote = null;

            protected void textChanged(DocumentEvent e) {
                VirtualFile newRoot = GitPushDialog.this.getGitRoot();
                GitRemote newRemote = GitPushDialog.this.getRemote(GitPushDialog.this.getRemoteTextField().getText());
                if (newRoot == null) {
                    return;
                }
                if (this.myPreviousRoot == null || this.myPreviousRemote == null || !this.myPreviousRoot.equals(newRoot) || !this.myPreviousRemote.equals(newRemote)) {
                    if (GitPushDialog.this.isMirror()) {
                        GitPushDialog.this.myPushPolicy.setEnabled(false);
                        GitPushDialog.this.myPushPolicy.setSelectedItem(PUSH_POLICY_MIRROR);
                    } else if (!GitPushDialog.this.myPushPolicy.isEnabled()) {
                        GitPushDialog.this.myPushPolicy.setSelectedItem(PUSH_POLICY_SELECTED);
                        GitPushDialog.this.myPushPolicy.setEnabled(true);
                    }
                    this.myPreviousRoot = newRoot;
                    this.myPreviousRemote = newRemote;
                }
            }
        };
        this.getRemoteTextField().getDocument().addDocumentListener((DocumentListener)listener);
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.changedUpdate(null);
            }
        });
        listener.changedUpdate(null);
    }

    private void updateBranchChooser() {
        this.myBranchChooser.clear();
        String current = this.myCurrentBranch.getText();
        for (String b : this.myBranchNames) {
            this.myBranchChooser.addElement((Object)b, b.equals(current));
        }
        if (this.myShowTagsCheckBox.isSelected()) {
            for (String t : this.myTagNames) {
                this.myBranchChooser.addElement((Object)t, false);
            }
        }
        this.validateFields();
    }

    private boolean isMirror() {
        String name = this.getRemoteTextField().getText();
        Boolean rc = (Boolean)this.myMirrorChecks.get((Object)name);
        if (rc == null) {
            rc = false;
            GitRemote remote = this.getRemote(name);
            if (remote != null) {
                try {
                    rc = GitConfigUtil.getBoolValue(this.myProject, this.getGitRoot(), "remote." + name + ".mirror");
                    if (rc == null) {
                        rc = false;
                    }
                }
                catch (VcsException e) {
                    // empty catch block
                }
                this.myMirrorChecks.put((Object)name, (Object)rc);
            }
        }
        return rc;
    }

    @Nullable
    private GitRemote getRemote(String name) {
        for (int i = this.myRemoteComboBox.getItemCount() - 1; i >= 0; --i) {
            GitRemote r = (GitRemote)this.myRemoteComboBox.getItemAt(i);
            if (!name.equals(r.toString())) continue;
            return r;
        }
        return null;
    }

    private void setupRemotes() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPushDialog.this.updateRemotes();
                GitPushDialog.this.myMirrorChecks.clear();
                GitPushDialog.this.myBranchNames.clear();
                GitPushDialog.this.myTagNames.clear();
                try {
                    GitBranch.listAsStrings(GitPushDialog.this.myProject, GitPushDialog.this.getGitRoot(), false, true, GitPushDialog.this.myBranchNames);
                    GitTag.listAsStrings(GitPushDialog.this.myProject, GitPushDialog.this.getGitRoot(), GitPushDialog.this.myTagNames);
                }
                catch (VcsException ex) {
                    LOG.warn("Exception in branch list: \n" + StringUtil.getThrowableText((Throwable)ex));
                }
            }
        };
        this.myGitRootComboBox.addActionListener(actionListener);
        actionListener.actionPerformed(null);
    }

    private void updateRemotes() {
        GitUIUtil.setupRemotes(this.myProject, this.getGitRoot(), this.myRemoteComboBox, false);
    }

    private JTextField getRemoteTextField() {
        return (JTextField)this.myRemoteComboBox.getEditor().getEditorComponent();
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Push";
    }

    private void createUIComponents() {
        this.myBranchChooser = new ElementsChooser(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JComboBox jComboBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.remote"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.remote.tooltip"));
        jPanel.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPushTagsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.tags"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.tags.tooltip"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUseThinPackCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.use.thin.pack"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.use.thin.pack.tooltip"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForceUpdateCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.force.update"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.force.update.tooltip"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.policy"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPushPolicy = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.policy.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.branches"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(4, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        ElementsChooser<String> elementsChooser = this.myBranchChooser;
        elementsChooser.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.branches.tooltip"));
        jPanel3.add((Component)elementsChooser, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 7, null, null, null));
        this.myShowTagsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.show.tags"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.show.tags.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jComboBox3);
        jLabel3.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

