/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.GitBranchesSearcher;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitSimpleHandler;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GitOutgoingChangesProvider
implements VcsOutgoingChangesProvider<CommittedChangeList> {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.changes.GitOutgoingChangesProvider");
    private final Project myProject;

    public GitOutgoingChangesProvider(Project project) {
        this.myProject = project;
    }

    public Pair<VcsRevisionNumber, List<CommittedChangeList>> getOutgoingChanges(VirtualFile vcsRoot, boolean findRemote) throws VcsException {
        LOG.debug("getOutgoingChanges root: " + vcsRoot.getPath());
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, vcsRoot, findRemote);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            return new Pair(null, Collections.emptyList());
        }
        final GitRevisionNumber base = searcher.getLocal().getMergeBase(this.myProject, vcsRoot, searcher.getRemote());
        if (base == null) {
            return new Pair(null, Collections.emptyList());
        }
        List<CommittedChangeList> lists = GitUtil.getLocalCommittedChanges(this.myProject, vcsRoot, new Consumer<GitSimpleHandler>(){

            public void consume(GitSimpleHandler handler) {
                handler.addParameters(base.asString() + "..HEAD");
            }
        });
        return new Pair((Object)base, lists);
    }

    @Nullable
    public VcsRevisionNumber getMergeBaseNumber(VirtualFile anyFileUnderRoot) throws VcsException {
        LOG.debug("getMergeBaseNumber parameter: " + anyFileUnderRoot.getPath());
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = vcsManager.getVcsRootFor(anyFileUnderRoot);
        if (root == null) {
            LOG.info("VCS root not found");
            return null;
        }
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, root, true);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            LOG.info("local or remote not found");
            return null;
        }
        GitRevisionNumber base = searcher.getLocal().getMergeBase(this.myProject, root, searcher.getRemote());
        LOG.debug("found base: " + (base == null ? null : base.asString()));
        return base;
    }
}

