/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.checkin.GitPushDialog;
import git4idea.commands.GitHandlerUtil;
import git4idea.i18n.GitBundle;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitPush
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("push.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitPush.getActionName must not return null");
        }
        return string;
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitPush.perform must not be null");
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitPush.perform must not be null");
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitPush.perform must not be null");
        }
        GitPushDialog d = new GitPushDialog(project, gitRoots, defaultRoot);
        d.show();
        if (!d.isOK()) {
            return;
        }
        GitHandlerUtil.doSynchronously(d.handler(), GitBundle.getString("pushing.all.changes"), "git push");
    }
}

