/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitMerge
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("merge.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitMerge.getActionName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitMerge.perform must not be null");
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitMerge.perform must not be null");
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitMerge.perform must not be null");
        }
        GitMergeDialog dialog = new GitMergeDialog(project, gitRoots, defaultRoot);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        Label beforeLabel = LocalHistory.putSystemLabel((Project)project, (String)"Before update");
        GitLineHandler h = dialog.handler();
        VirtualFile root = dialog.getSelectedRoot();
        affectedRoots.add(root);
        GitRevisionNumber currentRev = GitRevisionNumber.resolve(project, root, "HEAD");
        try {
            GitHandlerUtil.doSynchronously(h, GitBundle.message("merging.title", dialog.getSelectedRoot().getPath()), h.printableCommandLine());
        }
        finally {
            exceptions.addAll(h.errors());
        }
        if (exceptions.size() != 0) {
            return;
        }
        GitMergeUtil.showUpdates(this, project, exceptions, root, currentRev, beforeLabel, this.getActionName(), ActionInfo.INTEGRATE);
    }
}

