/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ContentRevision {
    @NotNull
    private final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Charset myCharset;

    public GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset != null ? charset : file.getCharset(project);
    }

    public GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitContentRevision.<init> must not be null");
        }
        this(file, revision, project, null);
    }

    @Nullable
    public String getContent() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        VirtualFile root = GitUtil.getGitRoot(this.myFile);
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, root, GitCommand.SHOW);
        h.setCharset(this.myCharset);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters(this.myRevision.getRev() + ":" + GitUtil.relativePath(root, this.myFile));
        return h.run();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitContentRevision.getFile must not return null");
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        GitRevisionNumber gitRevisionNumber = this.myRevision;
        if (gitRevisionNumber == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitContentRevision.getRevisionNumber must not return null");
        }
        return gitRevisionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    public static ContentRevision createRevision(VirtualFile vcsRoot, String path, VcsRevisionNumber revisionNumber, Project project, boolean isDeleted) throws VcsException {
        FilePath file;
        String name = vcsRoot.getPath() + "/" + GitUtil.unescapePath(path);
        FilePath filePath = file = isDeleted ? VcsUtil.getFilePathForDeletedFile((String)name, (boolean)false) : VcsUtil.getFilePath((String)name, (boolean)false);
        if (revisionNumber != null) {
            return new GitContentRevision(file, (GitRevisionNumber)revisionNumber, project);
        }
        return CurrentContentRevision.create((FilePath)file);
    }

    public static ContentRevision createRevision(VirtualFile file, VcsRevisionNumber revisionNumber, Project project) throws VcsException {
        FilePathImpl filePath = new FilePathImpl(file);
        if (revisionNumber != null) {
            return new GitContentRevision((FilePath)filePath, (GitRevisionNumber)revisionNumber, project);
        }
        return CurrentContentRevision.create((FilePath)filePath);
    }
}

