/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.DeprecationException;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyClassLoader
extends URLClassLoader {
    protected final Map classCache = new HashMap();
    protected final Map sourceCache = new HashMap();
    private final CompilerConfiguration config;
    private Boolean recompile;
    private static int scriptNameCounter = 1000000;
    private GroovyResourceLoader resourceLoader = new GroovyResourceLoader(){

        public URL loadGroovySource(final String string) throws MalformedURLException {
            URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return GroovyClassLoader.this.getSourceFile(string);
                }
            });
            return uRL;
        }
    };

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public GroovyClassLoader(GroovyClassLoader groovyClassLoader) {
        this(groovyClassLoader, groovyClassLoader.config, false);
    }

    public GroovyClassLoader(ClassLoader classLoader, CompilerConfiguration compilerConfiguration, boolean bl) {
        super(new URL[0], classLoader);
        if (compilerConfiguration == null) {
            compilerConfiguration = CompilerConfiguration.DEFAULT;
        }
        this.config = compilerConfiguration;
        if (bl) {
            for (String string : compilerConfiguration.getClasspath()) {
                this.addClasspath(string);
            }
        }
    }

    public GroovyClassLoader(ClassLoader classLoader, CompilerConfiguration compilerConfiguration) {
        this(classLoader, compilerConfiguration, true);
    }

    public void setResourceLoader(GroovyResourceLoader groovyResourceLoader) {
        if (groovyResourceLoader == null) {
            throw new IllegalArgumentException("Resource loader must not be null!");
        }
        this.resourceLoader = groovyResourceLoader;
    }

    public GroovyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Class defineClass(ClassNode classNode, String string) {
        throw new DeprecationException("the method GroovyClassLoader#defineClass(ClassNode, String) is no longer used and removed");
    }

    public Class defineClass(ClassNode classNode, String string, String string2) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", string2), (Certificate[])null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        CompilationUnit compilationUnit = this.createCompilationUnit(this.config, codeSource);
        ClassCollector classCollector = this.createCollector(compilationUnit, classNode.getModule().getContext());
        try {
            compilationUnit.addClassNode(classNode);
            compilationUnit.setClassgenCallback(classCollector);
            compilationUnit.compile(7);
            return classCollector.generatedClass;
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new RuntimeException(compilationFailedException);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String string, String string2) throws CompilationFailedException {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.config.getSourceEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CompilationFailedException(1, null, unsupportedEncodingException);
        }
        return this.parseClass(new ByteArrayInputStream(byArray), string2);
    }

    public Class parseClass(String string) throws CompilationFailedException {
        return this.parseClass(string, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream inputStream) throws CompilationFailedException {
        return this.parseClass(inputStream, this.generateScriptName());
    }

    public synchronized String generateScriptName() {
        return "script" + ++scriptNameCounter + ".groovy";
    }

    public Class parseClass(final InputStream inputStream, final String string) throws CompilationFailedException {
        GroovyCodeSource groovyCodeSource = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(inputStream, string, "/groovy/script");
            }
        });
        return this.parseClass(groovyCodeSource);
    }

    public Class parseClass(GroovyCodeSource groovyCodeSource) throws CompilationFailedException {
        return this.parseClass(groovyCodeSource, groovyCodeSource.isCachable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource groovyCodeSource, boolean bl) throws CompilationFailedException {
        Map map = this.sourceCache;
        synchronized (map) {
            Class clazz = (Class)this.sourceCache.get(groovyCodeSource.getName());
            if (clazz != null) {
                return clazz;
            }
            CompilationUnit compilationUnit = this.createCompilationUnit(this.config, groovyCodeSource.getCodeSource());
            SourceUnit sourceUnit = null;
            sourceUnit = groovyCodeSource.getFile() == null ? compilationUnit.addSource(groovyCodeSource.getName(), groovyCodeSource.getInputStream()) : compilationUnit.addSource(groovyCodeSource.getFile());
            ClassCollector classCollector = this.createCollector(compilationUnit, sourceUnit);
            compilationUnit.setClassgenCallback(classCollector);
            int n = 7;
            if (this.config != null && this.config.getTargetDirectory() != null) {
                n = 8;
            }
            compilationUnit.compile(n);
            clazz = classCollector.generatedClass;
            for (Class clazz2 : classCollector.getLoadedClasses()) {
                this.setClassCacheEntry(clazz2);
            }
            if (bl) {
                this.sourceCache.put(groovyCodeSource.getName(), clazz);
            }
            return clazz;
        }
    }

    protected String[] getClassPath() {
        URL[] uRLArray = this.getURLs();
        String[] stringArray = new String[uRLArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = uRLArray[i].getFile();
        }
        return stringArray;
    }

    protected void expandClassPath(List list, String string, String string2, boolean bl) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#expandClassPath(List,String,String,boolean) is no longer used internally and removed");
    }

    protected Class defineClass(String string, byte[] byArray, ProtectionDomain protectionDomain) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#defineClass(String,byte[],ProtectionDomain) is no longer used internally and removed");
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection;
        try {
            permissionCollection = super.getPermissions(codeSource);
        }
        catch (SecurityException securityException) {
            permissionCollection = new Permissions();
        }
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return this.getClass().getProtectionDomain();
            }
        });
        PermissionCollection permissionCollection2 = protectionDomain.getPermissions();
        if (permissionCollection2 != null) {
            Enumeration<Permission> enumeration = permissionCollection2.elements();
            while (enumeration.hasMoreElements()) {
                permissionCollection.add(enumeration.nextElement());
            }
        }
        permissionCollection.setReadOnly();
        return permissionCollection;
    }

    protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
        return new CompilationUnit(compilerConfiguration, codeSource, this);
    }

    protected ClassCollector createCollector(CompilationUnit compilationUnit, SourceUnit sourceUnit) {
        InnerLoader innerLoader = (InnerLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new InnerLoader(GroovyClassLoader.this);
            }
        });
        return new ClassCollector(innerLoader, compilationUnit, sourceUnit);
    }

    public Class defineClass(String string, byte[] byArray) {
        return super.defineClass(string, byArray, 0, byArray.length);
    }

    public Class loadClass(String string, boolean bl, boolean bl2) throws ClassNotFoundException, CompilationFailedException {
        return this.loadClass(string, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getClassCacheEntry(String string) {
        if (string == null) {
            return null;
        }
        Map map = this.classCache;
        synchronized (map) {
            return (Class)this.classCache.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClassCacheEntry(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.put(clazz.getName(), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClassCacheEntry(String string) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.remove(string);
        }
    }

    public void addURL(URL uRL) {
        super.addURL(uRL);
    }

    protected boolean isRecompilable(Class clazz) {
        if (clazz == null) {
            return true;
        }
        if (clazz.getClassLoader() == this) {
            return false;
        }
        if (this.recompile == null && !this.config.getRecompileGroovySource()) {
            return false;
        }
        if (this.recompile != null && !this.recompile.booleanValue()) {
            return false;
        }
        if (!GroovyObject.class.isAssignableFrom(clazz)) {
            return false;
        }
        long l = this.getTimeStamp(clazz);
        return l != Long.MAX_VALUE;
    }

    public void setShouldRecompile(Boolean bl) {
        this.recompile = bl;
    }

    public Boolean isShouldRecompile() {
        return this.recompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String string, boolean bl, boolean bl2, boolean bl3) throws ClassNotFoundException, CompilationFailedException {
        Object object;
        int n;
        Object object2;
        Class clazz = this.getClassCacheEntry(string);
        boolean bl4 = this.isRecompilable(clazz);
        if (!bl4) {
            return clazz;
        }
        ClassNotFoundException classNotFoundException = null;
        try {
            object2 = super.loadClass(string, bl3);
            if (clazz != object2) {
                return object2;
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (noClassDefFoundError.getMessage().indexOf("wrong name") <= 0) {
                throw noClassDefFoundError;
            }
            classNotFoundException = new ClassNotFoundException(string);
        }
        object2 = System.getSecurityManager();
        if (object2 != null && (n = ((String)(object = string.replace('/', '.'))).lastIndexOf(46)) != -1 && !((String)object).startsWith("sun.reflect.")) {
            ((SecurityManager)object2).checkPackageAccess(((String)object).substring(0, n));
        }
        if (clazz != null && bl2) {
            return clazz;
        }
        if (bl) {
            object = this.sourceCache;
            synchronized (object) {
                try {
                    Class clazz2 = this.getClassCacheEntry(string);
                    if (clazz2 != clazz) {
                        Class clazz3 = clazz2;
                        return clazz3;
                    }
                    URL uRL = this.resourceLoader.loadGroovySource(string);
                    clazz = this.recompile(uRL, string, clazz);
                }
                catch (IOException iOException) {
                    classNotFoundException = new ClassNotFoundException("IOException while opening groovy source: " + string, iOException);
                }
                finally {
                    if (clazz == null) {
                        this.removeClassCacheEntry(string);
                    } else {
                        this.setClassCacheEntry(clazz);
                    }
                }
            }
        }
        if (clazz != null) {
            return clazz;
        }
        if (classNotFoundException == null) {
            throw new AssertionError(true);
        }
        throw classNotFoundException;
    }

    protected Class recompile(URL uRL, String string, Class clazz) throws CompilationFailedException, IOException {
        if (uRL != null && (clazz != null && this.isSourceNewer(uRL, clazz) || clazz == null)) {
            this.sourceCache.remove(string);
            return this.parseClass(uRL.openStream(), string);
        }
        return clazz;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(string, true, true, bl);
    }

    protected long getTimeStamp(Class clazz) {
        return Verifier.getTimestamp(clazz);
    }

    private String decodeFileName(String string) {
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Encounted an invalid encoding scheme when trying to use URLDecoder.decode() inside of the GroovyClassLoader.decodeFileName() method.  Returning the unencoded URL.");
            System.err.println("Please note that if you encounter this error and you have spaces in your directory you will run into issues.  Refer to GROOVY-1787 for description of this bug.");
        }
        return string2;
    }

    private URL getSourceFile(String string) {
        String string2 = string.replace('.', '/') + this.config.getDefaultScriptExtension();
        URL uRL = this.getResource(string2);
        if (uRL != null && uRL.getProtocol().equals("file")) {
            File file;
            File file2;
            String string3 = string2;
            if (string3.indexOf(47) != -1) {
                int n = string3.lastIndexOf(47);
                string3 = string3.substring(n + 1);
            }
            if ((file2 = new File(this.decodeFileName(uRL.getFile())).getParentFile()).exists() && file2.isDirectory() && (file = new File(file2, string3)).exists()) {
                File file3 = file.getParentFile();
                String[] stringArray = file3.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string3)) continue;
                    return uRL;
                }
            }
            return null;
        }
        return uRL;
    }

    protected boolean isSourceNewer(URL uRL, Class clazz) throws IOException {
        long l;
        Object object;
        if (uRL.getProtocol().equals("file")) {
            object = uRL.getPath().replace('/', File.separatorChar).replace('|', ':');
            File file = new File((String)object);
            l = file.lastModified();
        } else {
            object = uRL.openConnection();
            l = ((URLConnection)object).getLastModified();
            ((URLConnection)object).getInputStream().close();
        }
        long l2 = this.getTimeStamp(clazz);
        return l2 + (long)this.config.getMinimumRecompilationInterval() < l;
    }

    public void addClasspath(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File file = new File(string);
                    URL uRL = file.toURI().toURL();
                    URL[] uRLArray = GroovyClassLoader.this.getURLs();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (!uRLArray[i].equals(uRL)) continue;
                        return null;
                    }
                    GroovyClassLoader.this.addURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getLoadedClasses() {
        Map map = this.classCache;
        synchronized (map) {
            Collection collection = this.classCache.values();
            return collection.toArray(new Class[collection.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.clear();
        }
        map = this.sourceCache;
        synchronized (map) {
            this.sourceCache.clear();
        }
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private final GroovyClassLoader cl;
        private final SourceUnit su;
        private final CompilationUnit unit;
        private final Collection loadedClasses;

        protected ClassCollector(InnerLoader innerLoader, CompilationUnit compilationUnit, SourceUnit sourceUnit) {
            this.cl = innerLoader;
            this.unit = compilationUnit;
            this.loadedClasses = new ArrayList();
            this.su = sourceUnit;
        }

        protected GroovyClassLoader getDefiningClassLoader() {
            return this.cl;
        }

        protected Class createClass(byte[] byArray, ClassNode classNode) {
            GroovyClassLoader groovyClassLoader = this.getDefiningClassLoader();
            Class clazz = groovyClassLoader.defineClass(classNode.getName(), byArray, 0, byArray.length, this.unit.getAST().getCodeSource());
            this.loadedClasses.add(clazz);
            if (this.generatedClass == null) {
                ModuleNode moduleNode = classNode.getModule();
                SourceUnit sourceUnit = null;
                if (moduleNode != null) {
                    sourceUnit = moduleNode.getContext();
                }
                ClassNode classNode2 = null;
                if (moduleNode != null) {
                    classNode2 = (ClassNode)moduleNode.getClasses().get(0);
                }
                if (sourceUnit == this.su && classNode2 == classNode) {
                    this.generatedClass = clazz;
                }
            }
            return clazz;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] byArray = classWriter.toByteArray();
            return this.createClass(byArray, classNode);
        }

        public void call(ClassVisitor classVisitor, ClassNode classNode) {
            this.onClassNode((ClassWriter)classVisitor, classNode);
        }

        public Collection getLoadedClasses() {
            return this.loadedClasses;
        }
    }

    public static class InnerLoader
    extends GroovyClassLoader {
        private final GroovyClassLoader delegate;
        private final long timeStamp;

        public InnerLoader(GroovyClassLoader groovyClassLoader) {
            super(groovyClassLoader);
            this.delegate = groovyClassLoader;
            this.timeStamp = System.currentTimeMillis();
        }

        public void addClasspath(String string) {
            this.delegate.addClasspath(string);
        }

        public void clearCache() {
            this.delegate.clearCache();
        }

        public URL findResource(String string) {
            return this.delegate.findResource(string);
        }

        public Enumeration findResources(String string) throws IOException {
            return this.delegate.findResources(string);
        }

        public Class[] getLoadedClasses() {
            return this.delegate.getLoadedClasses();
        }

        public URL getResource(String string) {
            return this.delegate.getResource(string);
        }

        public InputStream getResourceAsStream(String string) {
            return this.delegate.getResourceAsStream(string);
        }

        public GroovyResourceLoader getResourceLoader() {
            return this.delegate.getResourceLoader();
        }

        public URL[] getURLs() {
            return this.delegate.getURLs();
        }

        public Class loadClass(String string, boolean bl, boolean bl2, boolean bl3) throws ClassNotFoundException, CompilationFailedException {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            return this.delegate.loadClass(string, bl, bl2, bl3);
        }

        public Class parseClass(GroovyCodeSource groovyCodeSource, boolean bl) throws CompilationFailedException {
            return this.delegate.parseClass(groovyCodeSource, bl);
        }

        public void setResourceLoader(GroovyResourceLoader groovyResourceLoader) {
            this.delegate.setResourceLoader(groovyResourceLoader);
        }

        public void addURL(URL uRL) {
            this.delegate.addURL(uRL);
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

