/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.util.StringUtil;

public class FileUtil {
    private FileUtil() {
    }

    public static String readFile(String resource) throws IOException {
        BufferedInputStream in = new BufferedInputStream(FileUtil.class.getResourceAsStream(resource));
        return FileUtil.readFileContent(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new BufferedInputStream(fis);
            String string = FileUtil.readFileContent(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static String readFileContent(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = in.read();
        while (i != -1) {
            buf.append((char)i);
            i = in.read();
        }
        return StringUtil.fixLineBreaks(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String filename, String content) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(filename);
            bos = new BufferedOutputStream(fos);
            ((BufferedOutputStream)bos).write(content.getBytes(), 0, content.length());
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Nullable
    public static String getFileExtension(String filename) {
        File file = new File(filename);
        int pos = file.getName().lastIndexOf(".");
        if (pos == -1) {
            return null;
        }
        return filename.substring(pos + 1);
    }

    public static boolean existsFile(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static boolean deleteFile(String filename) {
        File file = new File(filename);
        return file.delete();
    }

    public static String stripFilename(String filename) {
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos != -1) {
            return filename.substring(pos + 1);
        }
        return filename;
    }
}

