/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.element;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import org.jetbrains.generate.tostring.element.AbstractElement;
import org.jetbrains.generate.tostring.element.ClassElement;
import org.jetbrains.generate.tostring.element.FieldElement;
import org.jetbrains.generate.tostring.element.MethodElement;
import org.jetbrains.generate.tostring.psi.PsiAdapter;

public class ElementFactory {
    private static final Logger log = Logger.getInstance((String)"#org.jetbrains.generate.tostring.element.ElementFactory");

    private ElementFactory() {
    }

    public static ClassElement newClassElement(Project project, PsiClass clazz, PsiAdapter psi) {
        ClassElement ce = new ClassElement();
        ce.setName(clazz.getName());
        ce.setQualifiedName(clazz.getQualifiedName());
        ce.setHasSuper(psi.hasSuperClass(project, clazz));
        PsiClass superClass = psi.getSuperClass(project, clazz);
        ce.setSuperName(superClass == null ? null : superClass.getName());
        ce.setSuperQualifiedName(superClass == null ? null : superClass.getQualifiedName());
        ce.setImplementNames(psi.getImplementsClassnames(clazz));
        ce.setEnum(clazz.isEnum());
        ce.setDeprecated(clazz.isDeprecated());
        ce.setException(PsiAdapter.isExceptionClass(clazz));
        ce.setAbstract(psi.isAbstractClass(clazz));
        return ce;
    }

    public static FieldElement newFieldElement(Project project, PsiField field, PsiAdapter psi) {
        PsiModifierList modifiers;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        FieldElement fe = new FieldElement();
        PsiType type = field.getType();
        fe.setName(field.getName());
        if (psi.isConstantField(field)) {
            fe.setConstant(true);
        }
        if (psi.isEnumField(field)) {
            fe.setEnum(true);
        }
        if ((modifiers = field.getModifierList()) != null) {
            if (modifiers.hasModifierProperty("transient")) {
                fe.setModifierTransient(true);
            }
            if (modifiers.hasModifierProperty("volatile")) {
                fe.setModifierVolatile(true);
            }
        }
        ElementFactory.setElementInfo(fe, factory, type, modifiers, psi);
        return fe;
    }

    public static MethodElement newMethodElement(PsiMethod method, PsiElementFactory factory, PsiAdapter psi) {
        MethodElement me = new MethodElement();
        PsiType type = method.getReturnType();
        PsiModifierList modifiers = method.getModifierList();
        if (type == null) {
            log.warn("This method does not have a valid return type: " + method.getName() + ", returnType=" + type);
            return me;
        }
        ElementFactory.setElementInfo(me, factory, type, modifiers, psi);
        String fieldName = psi.getGetterFieldName(factory, method);
        me.setName(fieldName == null ? method.getName() : fieldName);
        me.setFieldName(fieldName);
        me.setMethodName(method.getName());
        me.setGetter(psi.isGetterMethod(factory, method));
        me.setReturnTypeVoid(psi.isTypeOfVoid(method.getReturnType()));
        me.setDeprecated(method.isDeprecated());
        if (modifiers.hasModifierProperty("abstract")) {
            me.setModifierAbstract(true);
        }
        if (modifiers.hasModifierProperty("synchronized")) {
            me.setModifierSynchronzied(true);
        }
        return me;
    }

    private static void setElementInfo(AbstractElement element, PsiElementFactory factory, PsiType type, PsiModifierList modifiers, PsiAdapter psi) {
        element.setTypeName(psi.getTypeClassName(type));
        element.setTypeQualifiedName(psi.getTypeQualifiedClassName(type));
        if (psi.isObjectArrayType(type)) {
            element.setObjectArray(true);
            element.setArray(true);
            if (psi.isStringArrayType(type)) {
                element.setStringArray(true);
            }
        } else if (psi.isPrimitiveArrayType(type)) {
            element.setPrimitiveArray(true);
            element.setArray(true);
        }
        if (psi.isCollectionType(factory, type)) {
            element.setCollection(true);
        }
        if (psi.isListType(factory, type)) {
            element.setList(true);
        }
        if (psi.isSetType(factory, type)) {
            element.setSet(true);
        }
        if (psi.isMapType(factory, type)) {
            element.setMap(true);
        }
        if (psi.isPrimitiveType(type)) {
            element.setPrimitive(true);
        }
        if (psi.isObjectType(factory, type)) {
            element.setObject(true);
        }
        if (psi.isStringType(factory, type)) {
            element.setString(true);
        }
        if (psi.isNumericType(factory, type)) {
            element.setNumeric(true);
        }
        if (psi.isDateType(factory, type)) {
            element.setDate(true);
        }
        if (psi.isCalendarType(factory, type)) {
            element.setCalendar(true);
        }
        if (psi.isBooleanType(factory, type)) {
            element.setBoolean(true);
        }
        if (modifiers != null) {
            if (modifiers.hasModifierProperty("static")) {
                element.setModifierStatic(true);
            }
            if (modifiers.hasModifierProperty("final")) {
                element.setModifierFinal(true);
            }
            if (modifiers.hasModifierProperty("public")) {
                element.setModifierPublic(true);
            } else if (modifiers.hasModifierProperty("protected")) {
                element.setModifierProtected(true);
            } else if (modifiers.hasModifierProperty("packageLocal")) {
                element.setModifierPackageLocal(true);
            } else if (modifiers.hasModifierProperty("private")) {
                element.setModifierPrivate(true);
            }
        }
    }
}

