/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nullable;

enum InitializerRequirement {
    NONE_REQUIRED,
    VALUE_REQUIRED,
    OTHER_REQUIRED;


    public static InitializerRequirement calcInitializerRequirement(@Nullable PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null || !psiClass.isAnnotationType()) {
            return NONE_REQUIRED;
        }
        InitializerRequirement r = NONE_REQUIRED;
        for (PsiMethod method : methods = psiClass.getMethods()) {
            PsiAnnotationMethod annotationMethod;
            if (!(method instanceof PsiAnnotationMethod) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null) continue;
            if ("value".equals(annotationMethod.getName())) {
                return VALUE_REQUIRED;
            }
            r = OTHER_REQUIRED;
        }
        return r;
    }
}

