/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern.compiler.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.pattern.compiler.AnnotationBasedInstrumentingCompiler;
import org.intellij.plugins.intelliLang.pattern.compiler.Instrumenter;
import org.intellij.plugins.intelliLang.pattern.compiler.impl.PatternValidationInstrumenter;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class PatternValidationCompiler
extends AnnotationBasedInstrumentingCompiler {
    private final Map<String, String> myAnnotations = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getAnnotationNames(Project project) {
        Map<String, String> map = this.myAnnotations;
        synchronized (map) {
            this.myAnnotations.clear();
            final Pair<String, ? extends Set<String>> patternAnnotation = Configuration.getInstance().getPatternAnnotationPair();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass((String)patternAnnotation.first, scope);
            if (psiClass == null) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            Query query = AnnotatedMembersSearch.search((PsiClass)psiClass, (SearchScope)GlobalSearchScope.allScope((Project)project));
            query.forEach((Processor)new Processor<PsiMember>(){

                public boolean process(PsiMember psiMember) {
                    String s;
                    PsiAnnotation annotation;
                    PsiClass clazz;
                    if (psiMember instanceof PsiClass && (clazz = (PsiClass)psiMember).isAnnotationType() && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (Set)((Set)patternAnnotation.second))) != null && (s = AnnotationUtilEx.calcAnnotationValue(annotation, "value")) != null) {
                        PatternValidationCompiler.this.myAnnotations.put(clazz.getQualifiedName(), s);
                    }
                    return true;
                }
            });
            this.myAnnotations.put((String)patternAnnotation.first, null);
            Set<String> names = this.myAnnotations.keySet();
            return ArrayUtil.toStringArray(names);
        }
    }

    @Override
    protected boolean isEnabled() {
        Configuration.InstrumentationType option = Configuration.getInstance().getInstrumentation();
        return option == Configuration.InstrumentationType.ASSERT || option == Configuration.InstrumentationType.EXCEPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Instrumenter createInstrumenter(ClassWriter classwriter) {
        Map<String, String> map = this.myAnnotations;
        // MONITORENTER : map
        Configuration.InstrumentationType instrumentation = Configuration.getInstance().getInstrumentation();
        PatternValidationInstrumenter patternValidationInstrumenter = new PatternValidationInstrumenter(new HashMap<String, String>(this.myAnnotations), (ClassVisitor)classwriter, instrumentation);
        // MONITOREXIT : map
        if (patternValidationInstrumenter != null) return patternValidationInstrumenter;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/pattern/compiler/impl/PatternValidationCompiler.createInstrumenter must not return null");
    }

    @Override
    protected String getProgressMessage() {
        return "Inserting @Pattern assertions";
    }

    @NotNull
    public String getDescription() {
        if ("Pattern Validation" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/pattern/compiler/impl/PatternValidationCompiler.getDescription must not return null");
        }
        return "Pattern Validation";
    }
}

