/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.java.LanguageReference;
import org.intellij.plugins.intelliLang.inject.java.RegExpEnumReference;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

final class LanguageReferenceProvider
extends PsiReferenceContributor {
    private final Configuration myConfig = Configuration.getInstance();
    private final Computable<String> ANNOTATION_NAME = new Computable<String>(){

        public String compute() {
            return LanguageReferenceProvider.this.myConfig.getLanguageAnnotationClass();
        }
    };

    LanguageReferenceProvider() {
    }

    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().annotationParam((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("isLanguageAnnotation"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$3.accepts must not be null");
                }
                return Comparing.equal((String)((String)LanguageReferenceProvider.this.ANNOTATION_NAME.compute()), (String)s);
            }
        }), "value")).and((ElementPattern)PsiJavaPatterns.literalExpression().with((PatternCondition)new PatternCondition<PsiLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull PsiLiteralExpression expression, ProcessingContext context) {
                if (expression == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$2.accepts must not be null");
                }
                return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)expression);
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$4.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$4.getReferencesByElement must not be null");
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new LanguageReference((PsiLiteralExpression)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$4.getReferencesByElement must not return null");
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().with((PatternCondition)new PatternCondition<PsiLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull PsiLiteralExpression expression, ProcessingContext context) {
                if (expression == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$5.accepts must not be null");
                }
                return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)expression);
            }
        }), new PsiReferenceProvider(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
                PsiReference[] psiReferenceArray;
                String pattern;
                PsiAnnotation[] annotations;
                if (psiElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$6.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$6.getReferencesByElement must not be null");
                }
                PsiLiteralExpression expression = (PsiLiteralExpression)psiElement;
                PsiModifierListOwner owner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION);
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner) && (annotations = AnnotationUtilEx.getAnnotationFrom(owner, LanguageReferenceProvider.this.myConfig.getPatternAnnotationPair(), true)).length > 0 && (pattern = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null) {
                    psiReferenceArray = new PsiReference[]{new RegExpEnumReference(expression, pattern)};
                    if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$6.getReferencesByElement must not return null");
                    return psiReferenceArray;
                }
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/LanguageReferenceProvider$6.getReferencesByElement must not return null");
            }
        });
    }
}

