/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui.configurables;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.inject.config.Injection;
import org.intellij.plugins.intelliLang.inject.config.ui.InjectionPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class InjectionConfigurable<T extends Injection, P extends InjectionPanel<T>>
extends NamedConfigurable<T> {
    private final Runnable myTreeUpdater;
    protected final T myInjection;
    protected final Project myProject;
    private P myPanel;

    public InjectionConfigurable(T injection, Runnable treeUpdater, Project project) {
        this.myProject = project;
        this.myInjection = injection;
        this.myTreeUpdater = treeUpdater;
    }

    public void setDisplayName(String name) {
    }

    public T getEditableObject() {
        return this.myInjection;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public JComponent createOptionsPanel() {
        this.myPanel = this.createOptionsPanelImpl();
        this.myPanel.addUpdater(this.myTreeUpdater);
        return this.myPanel.getComponent();
    }

    protected abstract P createOptionsPanelImpl();

    public P getPanel() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    public String getDisplayName() {
        P p = this.getPanel();
        return p != null ? p.getInjection().getDisplayName() : this.myInjection.getDisplayName();
    }
}

