/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.intellij.plugins.intelliLang.PatternBasedInjectionHelper;
import org.intellij.plugins.intelliLang.inject.config.Injection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseInjection
implements Injection,
PersistentStateComponent<Element> {
    public static final Key<BaseInjection> INJECTION_KEY = Key.create((String)"INJECTION_KEY");
    @NotNull
    private final String mySupportId;
    private String myDisplayName;
    private String myInjectedLanguageId = "";
    private String myPrefix = "";
    private String mySuffix = "";
    @NonNls
    private String myValuePattern = "";
    private Pattern myCompiledValuePattern;
    private boolean mySingleFile;
    @NotNull
    private final List<InjectionPlace> myPlaces = new ArrayList<InjectionPlace>();

    public BaseInjection(String id) {
        this.mySupportId = id;
    }

    @NotNull
    public List<InjectionPlace> getInjectionPlaces() {
        List<InjectionPlace> list = this.myPlaces;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getInjectionPlaces must not return null");
        }
        return list;
    }

    @NotNull
    public String getSupportId() {
        String string = this.mySupportId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getSupportId must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getInjectedLanguageId() {
        String string = this.myInjectedLanguageId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getInjectedLanguageId must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getDisplayName must not return null");
        }
        return string;
    }

    public void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    public void setInjectedLanguageId(@NotNull String injectedLanguageId) {
        if (injectedLanguageId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/BaseInjection.setInjectedLanguageId must not be null");
        }
        this.myInjectedLanguageId = injectedLanguageId;
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getPrefix must not return null");
        }
        return string;
    }

    public void setPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/BaseInjection.setPrefix must not be null");
        }
        this.myPrefix = prefix;
    }

    @Override
    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getSuffix must not return null");
        }
        return string;
    }

    public void setSuffix(@NotNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/BaseInjection.setSuffix must not be null");
        }
        this.mySuffix = suffix;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<TextRange> getInjectedArea(PsiElement element) {
        List<Object> list;
        final TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (this.myCompiledValuePattern == null) {
            list = Collections.singletonList(textRange);
            if (list == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getInjectedArea must not return null");
            return list;
        }
        final LiteralTextEscaper textEscaper = ((PsiLanguageInjectionHost)element).createLiteralTextEscaper();
        StringBuilder sb = new StringBuilder();
        textEscaper.decode(textRange, sb);
        List<TextRange> ranges = BaseInjection.getMatchingRanges(this.myCompiledValuePattern.matcher(sb), sb.length());
        list = ranges.size() > 0 ? ContainerUtil.map(ranges, (Function)new Function<TextRange, TextRange>(){

            public TextRange fun(TextRange s) {
                return new TextRange(textEscaper.getOffsetInHost(s.getStartOffset(), textRange), textEscaper.getOffsetInHost(s.getEndOffset(), textRange));
            }
        }) : Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getInjectedArea must not return null");
    }

    public boolean isEnabled() {
        for (InjectionPlace place : this.myPlaces) {
            if (place.getElementPattern() == null || !place.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsPsiElement(PsiElement element) {
        ProgressManager.checkCanceled();
        for (InjectionPlace place : this.myPlaces) {
            if (!place.isEnabled() || place.getElementPattern() == null || !place.getElementPattern().accepts((Object)element)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsWith(BaseInjection template) {
        if (!Comparing.equal((String)this.getInjectedLanguageId(), (String)template.getInjectedLanguageId())) {
            return false;
        }
        for (InjectionPlace other : template.getInjectionPlaces()) {
            if (this.findPlaceByText(other.getText()) == null) continue;
            return true;
        }
        return false;
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!this.myInjectedLanguageId.equals(that.myInjectedLanguageId)) {
            return false;
        }
        if (!this.myPrefix.equals(that.myPrefix)) {
            return false;
        }
        if (!this.mySuffix.equals(that.mySuffix)) {
            return false;
        }
        if (!this.myValuePattern.equals(that.myValuePattern)) {
            return false;
        }
        return this.mySingleFile == that.mySingleFile;
    }

    @Nullable
    public InjectionPlace findPlaceByText(String text) {
        for (InjectionPlace cur : this.myPlaces) {
            if (!Comparing.equal((String)text, (String)cur.getText())) continue;
            return cur;
        }
        return null;
    }

    public BaseInjection copy() {
        return new BaseInjection(this.mySupportId).copyFrom(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaseInjection)) {
            return false;
        }
        BaseInjection that = (BaseInjection)o;
        if (!this.sameLanguageParameters(that)) {
            return false;
        }
        return ((Object)this.myPlaces).equals(that.myPlaces);
    }

    public int hashCode() {
        int result = this.myInjectedLanguageId.hashCode();
        result = 31 * result + this.myPrefix.hashCode();
        result = 31 * result + this.mySuffix.hashCode();
        result = 31 * result + this.myValuePattern.hashCode();
        return result;
    }

    public BaseInjection copyFrom(@NotNull BaseInjection other) {
        if (other == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/BaseInjection.copyFrom must not be null");
        }
        assert (this != other);
        this.myInjectedLanguageId = other.getInjectedLanguageId();
        this.myPrefix = other.getPrefix();
        this.mySuffix = other.getSuffix();
        this.myDisplayName = other.getDisplayName();
        this.setValuePattern(other.getValuePattern());
        this.mySingleFile = other.mySingleFile;
        this.myPlaces.clear();
        this.myPlaces.addAll(other.getInjectionPlaces());
        return this;
    }

    public void loadState(Element element) {
        Element e = element.getChild(this.getClass().getSimpleName());
        if (e != null) {
            this.myInjectedLanguageId = JDOMExternalizer.readString((Element)e, (String)"LANGUAGE");
            this.myPrefix = JDOMExternalizer.readString((Element)e, (String)"PREFIX");
            this.mySuffix = JDOMExternalizer.readString((Element)e, (String)"SUFFIX");
            this.setValuePattern(JDOMExternalizer.readString((Element)e, (String)"VALUE_PATTERN"));
            this.mySingleFile = JDOMExternalizer.readBoolean((Element)e, (String)"SINGLE_FILE");
            this.readExternalImpl(e);
            this.initializePlaces(false);
        } else {
            this.myDisplayName = StringUtil.notNullize((String)element.getChildText("display-name"));
            this.myInjectedLanguageId = StringUtil.notNullize((String)element.getAttributeValue("language"));
            this.myPrefix = StringUtil.notNullize((String)element.getChildText("prefix"));
            this.mySuffix = StringUtil.notNullize((String)element.getChildText("suffix"));
            this.setValuePattern(element.getChildText("value-pattern"));
            this.mySingleFile = element.getChild("single-file") != null;
            this.readExternalImpl(element);
            for (Element placeElement : element.getChildren("place")) {
                boolean enabled = !Boolean.parseBoolean(placeElement.getAttributeValue("disabled"));
                String text = placeElement.getText();
                this.myPlaces.add(new InjectionPlace(text, null, enabled));
            }
        }
    }

    public void initializePlaces(boolean compile) {
        if (this.myPlaces.isEmpty()) {
            for (String text : this.generatePlaces()) {
                this.myPlaces.add(new InjectionPlace(text, compile ? PatternBasedInjectionHelper.createElementPattern(text, this.getDisplayName(), this.getSupportId()) : null, true));
            }
        } else if (compile) {
            boolean replace = false;
            ArrayList<InjectionPlace> newPlaces = new ArrayList<InjectionPlace>();
            for (InjectionPlace place : this.myPlaces) {
                if (StringUtil.isNotEmpty((String)place.getText()) && place.getElementPattern() == null) {
                    replace = true;
                    newPlaces.add(new InjectionPlace(place.getText(), PatternBasedInjectionHelper.createElementPattern(place.getText(), this.getDisplayName(), this.getSupportId()), place.isEnabled()));
                    continue;
                }
                newPlaces.add(place);
            }
            if (replace) {
                this.myPlaces.clear();
                this.myPlaces.addAll(newPlaces);
            }
        }
    }

    protected List<String> generatePlaces() {
        return Collections.emptyList();
    }

    protected void readExternalImpl(Element e) {
    }

    public final Element getState() {
        Element e = new Element("injection");
        e.setAttribute("language", this.myInjectedLanguageId);
        e.setAttribute("injector-id", this.mySupportId);
        e.addContent(new Element("display-name").setText(this.getDisplayName()));
        if (StringUtil.isNotEmpty((String)this.myPrefix)) {
            e.addContent(new Element("prefix").setText(this.myPrefix));
        }
        if (StringUtil.isNotEmpty((String)this.mySuffix)) {
            e.addContent(new Element("suffix").setText(this.mySuffix));
        }
        if (StringUtil.isNotEmpty((String)this.myValuePattern)) {
            e.addContent(new Element("value-pattern").setText(this.myValuePattern));
        }
        if (this.mySingleFile) {
            e.addContent(new Element("single-file"));
        }
        ArrayList<InjectionPlace> places = new ArrayList<InjectionPlace>(this.myPlaces);
        Collections.sort(places, new Comparator<InjectionPlace>(){

            @Override
            public int compare(InjectionPlace o1, InjectionPlace o2) {
                return Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText()));
            }
        });
        for (InjectionPlace place : places) {
            Element child = new Element("place").setContent((Content)new CDATA(place.getText()));
            if (!place.isEnabled()) {
                child.setAttribute("disabled", "true");
            }
            e.addContent(child);
        }
        this.writeExternalImpl(e);
        return e;
    }

    protected void writeExternalImpl(Element e) {
    }

    @NotNull
    public String getValuePattern() {
        String string = this.myValuePattern;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/BaseInjection.getValuePattern must not return null");
        }
        return string;
    }

    public void setValuePattern(@RegExp @Nullable String pattern) {
        try {
            if (pattern != null && pattern.length() > 0) {
                this.myValuePattern = pattern;
                this.myCompiledValuePattern = Pattern.compile(pattern, 32);
            } else {
                this.myValuePattern = "";
                this.myCompiledValuePattern = null;
            }
        }
        catch (Exception e1) {
            this.myCompiledValuePattern = null;
            Logger.getInstance((String)this.getClass().getName()).info("Invalid pattern", (Throwable)e1);
        }
    }

    public boolean isSingleFile() {
        return this.mySingleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.mySingleFile = singleFile;
    }

    public boolean isTerminal() {
        return this.myCompiledValuePattern == null;
    }

    private static List<TextRange> getMatchingRanges(Matcher matcher, int length) {
        SmartList list = new SmartList();
        int start = 0;
        while (start < length && matcher.find(start)) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                start = matcher.end();
                continue;
            }
            for (int i = 1; i <= groupCount; ++i) {
                start = matcher.start(i);
                if (start == -1) continue;
                list.add(new TextRange(start, matcher.end(i)));
            }
            if (start >= matcher.end()) break;
            start = matcher.end();
        }
        return list;
    }

    public void mergeOriginalPlacesFrom(BaseInjection injection, boolean enabled) {
        for (InjectionPlace place : injection.getInjectionPlaces()) {
            if (this.findPlaceByText(place.getText()) != null) continue;
            if (enabled || !place.isEnabled()) {
                this.myPlaces.add(place);
                continue;
            }
            this.myPlaces.add(new InjectionPlace(place.getText(), place.getElementPattern(), false));
        }
    }

    public void setPlaceEnabled(@Nullable String text, boolean enabled) {
        for (int i = 0; i < this.myPlaces.size(); ++i) {
            InjectionPlace cur = this.myPlaces.get(i);
            if (text != null && !Comparing.equal((String)text, (String)cur.getText()) || cur.isEnabled() == enabled) continue;
            this.myPlaces.set(i, new InjectionPlace(cur.getText(), cur.getElementPattern(), enabled));
        }
    }

    public String toString() {
        return this.getInjectedLanguageId() + "->" + this.getDisplayName();
    }
}

