/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractTagInjection
extends BaseInjection {
    @NotNull
    @NonNls
    private StringMatcher myTagName = StringMatcher.ANY;
    @NotNull
    @NonNls
    private Set<String> myTagNamespace = Collections.emptySet();
    @NotNull
    @NonNls
    private String myXPathCondition = "";
    private Object myCompiledXPathCondition;
    private boolean myApplyToSubTagTexts;

    public AbstractTagInjection() {
        super("xml");
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName.getPattern();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.getTagName must not return null");
        }
        return string;
    }

    public void setTagName(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.setTagName must not be null");
        }
        this.myTagName = StringMatcher.create(tagName);
    }

    @Override
    public boolean acceptsPsiElement(PsiElement element) {
        return super.acceptsPsiElement(element) && (!(element instanceof XmlElement) || this.matchXPath((XmlElement)element));
    }

    @NotNull
    public String getTagNamespace() {
        String string = StringUtil.join(this.myTagNamespace, (String)"|");
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.getTagNamespace must not return null");
        }
        return string;
    }

    public void setTagNamespace(@NotNull @NonNls String tagNamespace) {
        if (tagNamespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.setTagNamespace must not be null");
        }
        this.myTagNamespace = new TreeSet<String>(StringUtil.split((String)tagNamespace, (String)"|"));
    }

    @NotNull
    public String getXPathCondition() {
        String string = this.myXPathCondition;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.getXPathCondition must not return null");
        }
        return string;
    }

    @Nullable
    public XPath getCompiledXPathCondition() {
        if (AbstractTagInjection.isInvalid(this.myCompiledXPathCondition)) {
            return null;
        }
        if (this.myCompiledXPathCondition != null) {
            return (XPath)this.myCompiledXPathCondition;
        }
        if (this.myXPathCondition != null && this.myXPathCondition.length() > 0) {
            try {
                XPathSupportProxy xPathSupport = XPathSupportProxy.getInstance();
                if (xPathSupport != null) {
                    this.myCompiledXPathCondition = xPathSupport.createXPath(this.myXPathCondition);
                    return this.myCompiledXPathCondition;
                }
                this.myCompiledXPathCondition = XPathSupportProxy.UNSUPPORTED;
            }
            catch (JaxenException e) {
                this.myCompiledXPathCondition = XPathSupportProxy.INVALID;
                Logger.getInstance((String)this.getClass().getName()).info("Invalid XPath expression", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean isInvalid(Object expr) {
        return expr == XPathSupportProxy.INVALID || expr == XPathSupportProxy.UNSUPPORTED;
    }

    public void setXPathCondition(@Nullable String condition) {
        this.myXPathCondition = condition != null ? condition : "";
        this.myCompiledXPathCondition = null;
    }

    protected boolean matches(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        if (!this.myTagName.matches(tag.getLocalName())) {
            return false;
        }
        return this.myTagNamespace.contains(tag.getNamespace());
    }

    @Override
    public AbstractTagInjection copy() {
        return new AbstractTagInjection().copyFrom(this);
    }

    @Override
    public AbstractTagInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection.copyFrom must not be null");
        }
        super.copyFrom(o);
        if (o instanceof AbstractTagInjection) {
            AbstractTagInjection other = (AbstractTagInjection)o;
            this.myTagName = other.myTagName;
            this.myTagNamespace = other.myTagNamespace;
            this.setXPathCondition(other.getXPathCondition());
            this.setApplyToSubTagTexts(other.isApplyToSubTagTexts());
        }
        return this;
    }

    @Override
    protected void readExternalImpl(Element e) {
        if (e.getAttribute("injector-id") == null) {
            this.setTagName(JDOMExternalizer.readString((Element)e, (String)"TAGNAME"));
            this.setTagNamespace(JDOMExternalizer.readString((Element)e, (String)"TAGNAMESPACE"));
            this.setXPathCondition(JDOMExternalizer.readString((Element)e, (String)"XPATH_CONDITION"));
            this.myApplyToSubTagTexts = JDOMExternalizer.readBoolean((Element)e, (String)"APPLY_TO_SUBTAGS");
        } else {
            this.setXPathCondition(e.getChildText("xpath-condition"));
            this.myApplyToSubTagTexts = e.getChild("apply-to-subtags") != null;
        }
    }

    @Override
    protected void writeExternalImpl(Element e) {
        if (StringUtil.isNotEmpty((String)this.myXPathCondition)) {
            e.addContent(new Element("xpath-condition").setText(this.myXPathCondition));
        }
        if (this.myApplyToSubTagTexts) {
            e.addContent(new Element("apply-to-subtags"));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTagInjection that = (AbstractTagInjection)o;
        if (!this.myTagName.equals(that.myTagName)) {
            return false;
        }
        if (!((Object)this.myTagNamespace).equals(that.myTagNamespace)) {
            return false;
        }
        if (!this.myXPathCondition.equals(that.myXPathCondition)) {
            return false;
        }
        return this.myApplyToSubTagTexts == that.myApplyToSubTagTexts;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myTagName.hashCode();
        result = 31 * result + ((Object)this.myTagNamespace).hashCode();
        result = 31 * result + this.myXPathCondition.hashCode();
        result = 31 * result + (this.myApplyToSubTagTexts ? 1 : 0);
        return result;
    }

    protected boolean matchXPath(XmlElement context) {
        XPath condition = this.getCompiledXPathCondition();
        if (condition != null) {
            try {
                return condition.booleanValueOf((Object)context);
            }
            catch (JaxenException e) {
                this.myCompiledXPathCondition = XPathSupportProxy.INVALID;
                return false;
            }
        }
        return this.myXPathCondition.length() == 0;
    }

    public boolean isApplyToSubTagTexts() {
        return this.myApplyToSubTagTexts;
    }

    public void setApplyToSubTagTexts(boolean applyToSubTagTexts) {
        this.myApplyToSubTagTexts = applyToSubTagTexts;
    }
}

