/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.MethodParameterInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.jetbrains.annotations.Nullable;

public class PatternBasedInjectionHelper {
    private PatternBasedInjectionHelper() {
    }

    public static List<String> getPatternString(MethodParameterInjection injection) {
        ArrayList<String> list = new ArrayList<String>();
        String className = injection.getClassName();
        for (MethodParameterInjection.MethodInfo info : injection.getMethodInfos()) {
            boolean[] paramFlags = info.getParamFlags();
            int paramFlagsLength = paramFlags.length;
            String methodName = info.getMethodName();
            String typesString = PatternBasedInjectionHelper.getParameterTypesString(info.getMethodSignature());
            if (info.isReturnFlag()) {
                list.add(PatternBasedInjectionHelper.getPatternStringForJavaPlace(methodName, typesString, -1, className));
            }
            for (int i = 0; i < paramFlagsLength; ++i) {
                if (!paramFlags[i]) continue;
                list.add(PatternBasedInjectionHelper.getPatternStringForJavaPlace(methodName, typesString, i, className));
            }
        }
        return list;
    }

    public static String getParameterTypesString(String signature) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(signature, "(,)");
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (i > 1) {
                sb.append(", ");
            }
            if (i != 0) {
                sb.append('\"');
                int idx = token.indexOf(32);
                if (idx > -1) {
                    sb.append(token.substring(0, idx));
                } else {
                    sb.append(token);
                }
                sb.append('\"');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getPatternStringForJavaPlace(String methodName, String parametersStrings, int parameterIndex, String className) {
        StringBuilder sb = new StringBuilder();
        if (parameterIndex >= 0) {
            sb.append("psiParameter().ofMethod(").append(parameterIndex).append(", ");
        }
        sb.append("psiMethod().withName(\"").append(methodName).append("\").withParameters(").append(parametersStrings).append(").definedInClass(\"").append(className).append("\")");
        if (parameterIndex >= 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getPatternString(XmlAttributeInjection injection) {
        String name = injection.getAttributeName();
        String namespace = injection.getAttributeNamespace();
        StringBuilder result = new StringBuilder("xmlAttribute()");
        if (StringUtil.isNotEmpty((String)name)) {
            result.append(".withLocalName(string().matches(\"").append(name).append("\"))");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            result.append(".withNamespace(string().matches(\"").append(namespace).append("\"))");
        }
        if (StringUtil.isNotEmpty((String)injection.getTagName()) || StringUtil.isNotEmpty((String)injection.getTagNamespace())) {
            result.append(".withParent(").append(PatternBasedInjectionHelper.getPatternString((AbstractTagInjection)injection)).append(")");
        }
        return result.toString();
    }

    public static String getPatternString(AbstractTagInjection injection) {
        String name = injection.getTagName();
        String namespace = injection.getTagNamespace();
        StringBuilder result = new StringBuilder("xmlTag()");
        if (StringUtil.isNotEmpty((String)name)) {
            result.append(".withLocalName(string().matches(\"").append(name).append("\"))");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            result.append(".withNamespace(string().matches(\"").append(namespace).append("\"))");
        }
        return result.toString();
    }

    @Nullable
    public static ElementPattern<PsiElement> createElementPattern(String text, String displayName, String supportId) {
        return PatternBasedInjectionHelper.createElementPatternNoException(text, displayName, supportId);
    }

    private static Class[] getPatternClasses(String supportId) {
        ArrayList<Class> patternClasses = new ArrayList<Class>();
        for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
            if (supportId != null && !supportId.equals(support.getId())) continue;
            patternClasses.addAll(Arrays.asList(support.getPatternClasses()));
        }
        return patternClasses.toArray(new Class[patternClasses.size()]);
    }

    @Nullable
    public static ElementPattern<PsiElement> createElementPatternNoException(String text, String displayName, String supportId) {
        try {
            return PatternBasedInjectionHelper.compileElementPattern(text, supportId);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            Configuration.LOG.warn("error processing place: " + displayName + " [" + text + "]", cause);
            return null;
        }
    }

    public static ElementPattern<PsiElement> compileElementPattern(final String text, String supportId) {
        final Set<Method> staticMethods = PatternBasedInjectionHelper.getStaticMethods(supportId);
        return PatternBasedInjectionHelper.createElementPatternNoGroovy(text, new Function<Frame, Object>(){

            public Object fun(Frame frame) {
                try {
                    return PatternBasedInjectionHelper.invokeMethod(frame.target, frame.methodName, frame.params.toArray(), staticMethods);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException(text, throwable);
                }
            }
        });
    }

    private static Set<Method> getStaticMethods(String supportId) {
        Object[] patternClasses = PatternBasedInjectionHelper.getPatternClasses(supportId);
        return new THashSet((Collection)ContainerUtil.concat((Object[])patternClasses, (Function)new Function<Class, Collection<? extends Method>>(){

            public Collection<Method> fun(Class aClass) {
                return ContainerUtil.findAll((Object[])ReflectionCache.getMethods((Class)aClass), (Condition)new Condition<Method>(){

                    public boolean value(Method method) {
                        return Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && ElementPattern.class.isAssignableFrom(method.getReturnType());
                    }
                });
            }
        }));
    }

    public static ElementPattern<PsiElement> createElementPatternNoGroovy(String text, Function<Frame, Object> executor) {
        Stack stack = new Stack();
        int curPos = 0;
        Frame curFrame = new Frame();
        Object curResult = null;
        StringBuilder curString = new StringBuilder();
        while (curPos <= text.length()) {
            char ch = curPos++ < text.length() ? text.charAt(curPos - 1) : (char)'\u0000';
            switch (curFrame.state) {
                case init: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        curFrame.state = State.name;
                        break;
                    }
                    throw new IllegalStateException("method call expected");
                }
                case name: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        curString.append(ch);
                        break;
                    }
                    if (ch == '(' || Character.isWhitespace(ch)) {
                        curFrame.methodName = curString.toString();
                        curString.setLength(0);
                        curFrame.state = ch == '(' ? State.param_start : State.name_end;
                        break;
                    }
                    throw new IllegalStateException("'" + curString + ch + "' method name start is invalid");
                }
                case name_end: {
                    if (ch == '(') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    throw new IllegalStateException("'(' expected after '" + curFrame.methodName + "'");
                }
                case param_start: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isDigit(ch) || ch == '\"') {
                        curFrame.state = State.literal;
                        curString.append(ch);
                        break;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        stack.push((Object)curFrame);
                        curFrame = new Frame();
                        curFrame.state = State.name;
                        break;
                    }
                    throw new IllegalStateException("expression expected in '" + curFrame.methodName + "' call");
                }
                case param_end: {
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    throw new IllegalStateException("')' or ',' expected in '" + curFrame.methodName + "' call");
                }
                case literal: {
                    if (curString.charAt(0) == '\"') {
                        curString.append(ch);
                        if (ch != '\"') break;
                        curFrame.params.add(PatternBasedInjectionHelper.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = State.param_end;
                        break;
                    }
                    if (Character.isWhitespace(ch) || ch == ',' || ch == ')') {
                        curFrame.params.add(PatternBasedInjectionHelper.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = ch == ')' ? State.invoke : (ch == ',' ? State.param_start : State.param_end);
                        break;
                    }
                    curString.append(ch);
                    break;
                }
                case invoke: {
                    curResult = executor.fun((Object)curFrame);
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (ElementPattern)curResult;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (ch == ',' || ch == ')') {
                        curFrame = (Frame)stack.pop();
                        curFrame.params.add(curResult);
                        curResult = null;
                        curFrame.state = ch == ')' ? State.invoke : State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        curFrame.state = State.invoke_end;
                        break;
                    }
                    throw new IllegalStateException((stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                }
                case invoke_end: {
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    throw new IllegalStateException((stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                }
            }
        }
        return null;
    }

    private static Object makeParam(String s) {
        if (s.length() > 2 && s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    public static Class<?> getNonPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    private static Object invokeMethod(@Nullable Object target, String methodName, Object[] arguments, Collection<Method> staticMethods) throws Throwable {
        block2: for (Method method : target == null ? staticMethods : Arrays.asList(target.getClass().getMethods())) {
            if (!methodName.equals(method.getName())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.isVarArgs() && parameterTypes.length != arguments.length) continue;
            boolean performArgConversion = false;
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < arguments.length; ++i) {
                Class<?> componentType;
                Class<?> type = PatternBasedInjectionHelper.getNonPrimitiveType(i < parameterTypesLength ? parameterTypes[i] : parameterTypes[parameterTypesLength - 1]);
                Object argument = arguments[i];
                Class<?> clazz = componentType = method.isVarArgs() && i < parameterTypesLength - 1 ? null : parameterTypes[parameterTypesLength - 1].getComponentType();
                if (argument == null || type.isInstance(argument)) continue;
                if (componentType == null || !componentType.isInstance(argument)) continue block2;
                performArgConversion = true;
            }
            if (parameterTypes.length > arguments.length) {
                performArgConversion = true;
            }
            try {
                Object[] newArgs;
                if (!performArgConversion) {
                    newArgs = arguments;
                } else {
                    newArgs = new Object[parameterTypes.length];
                    System.arraycopy(arguments, 0, newArgs, 0, parameterTypes.length - 1);
                    Object[] varArgs = (Object[])Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), arguments.length - parameterTypes.length + 1);
                    System.arraycopy(arguments, parameterTypes.length - 1, varArgs, 0, varArgs.length);
                    newArgs[parameterTypes.length - 1] = varArgs;
                }
                return method.invoke(target, newArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw new NoSuchMethodException("unknown symbol: " + methodName + "(" + StringUtil.join((Object[])arguments, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return String.valueOf(o);
            }
        }, (String)", ") + ")");
    }

    public static String dumpContextDeclarations(String injectorId) {
        Set<Method> methods = PatternBasedInjectionHelper.getStaticMethods(injectorId);
        StringBuilder sb = new StringBuilder();
        THashMap classes = new THashMap();
        THashSet missingClasses = new THashSet();
        classes.put(Object.class, (Object)missingClasses);
        for (Method method : methods) {
            for (Class<?> type = method.getReturnType(); type != null && ElementPattern.class.isAssignableFrom(type); type = type.getSuperclass()) {
                Class<?> enclosingClass = type.getEnclosingClass();
                if (enclosingClass != null) {
                    Collection list = (Collection)classes.get(enclosingClass);
                    if (list == null) {
                        list = new THashSet();
                        classes.put(enclosingClass, (Object)list);
                    }
                    list.add(type);
                    continue;
                }
                if (classes.containsKey(type)) continue;
                classes.put(type, null);
            }
        }
        for (Class aClass : classes.keySet()) {
            if (aClass == Object.class) continue;
            PatternBasedInjectionHelper.printClass(aClass, (Map<Class, Collection<Class>>)classes, sb);
        }
        for (Method method : methods) {
            PatternBasedInjectionHelper.printMethodDeclaration(method, sb, (Map<Class, Collection<Class>>)classes);
        }
        for (Class aClass : missingClasses) {
            sb.append("class ").append(aClass.getSimpleName());
            Class superclass = aClass.getSuperclass();
            if (missingClasses.contains(superclass)) {
                sb.append(" extends ").append(superclass.getSimpleName());
            }
            sb.append("{}\n");
        }
        return sb.toString();
    }

    private static void printClass(Class aClass, Map<Class, Collection<Class>> classes, StringBuilder sb) {
        boolean isInterface = aClass.isInterface();
        sb.append(isInterface ? "interface " : "class ");
        PatternBasedInjectionHelper.dumpType(aClass, aClass, sb, classes);
        Type superClass = aClass.getGenericSuperclass();
        Class rawSuperClass = (Class)(superClass instanceof ParameterizedType ? ((ParameterizedType)superClass).getRawType() : superClass);
        if (superClass != null && classes.containsKey(rawSuperClass)) {
            sb.append(" extends ");
            PatternBasedInjectionHelper.dumpType(null, superClass, sb, classes);
        }
        int implementsIdx = 1;
        for (Type superInterface : aClass.getGenericInterfaces()) {
            Class rawSuperInterface = (Class)(superInterface instanceof ParameterizedType ? ((ParameterizedType)superInterface).getRawType() : superClass);
            if (!classes.containsKey(rawSuperInterface)) continue;
            if (implementsIdx++ == 1) {
                sb.append(isInterface ? " extends " : " implements ");
            } else {
                sb.append(", ");
            }
            PatternBasedInjectionHelper.dumpType(null, superInterface, sb, classes);
        }
        sb.append(" {\n");
        for (Method method : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isVolatile(method.getModifiers())) continue;
            PatternBasedInjectionHelper.printMethodDeclaration(method, sb.append("  "), classes);
        }
        Collection<Class> innerClasses = classes.get(aClass);
        sb.append("}\n");
        if (innerClasses != null) {
            for (Class innerClass : innerClasses) {
                PatternBasedInjectionHelper.printClass(innerClass, classes, sb);
            }
        }
    }

    private static void dumpType(GenericDeclaration owner, Type type, StringBuilder sb, Map<Class, Collection<Class>> classes) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                sb.append(enclosingClass.getSimpleName()).append("_");
            } else if (!(aClass.isArray() || aClass.isPrimitive() || aClass.getName().startsWith("java.") || classes.containsKey(aClass))) {
                classes.get(Object.class).add(aClass);
            }
            sb.append(aClass.getSimpleName());
            if (owner == aClass) {
                PatternBasedInjectionHelper.dumpTypeParametersArray(owner, aClass.getTypeParameters(), sb, "<", ">", classes);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb.append(typeVariable.getName());
            if (typeVariable.getGenericDeclaration() == owner) {
                PatternBasedInjectionHelper.dumpTypeParametersArray(null, typeVariable.getBounds(), sb, " extends ", "", classes);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            sb.append("?");
            PatternBasedInjectionHelper.dumpTypeParametersArray(owner, wildcardType.getUpperBounds(), sb, " extends ", "", classes);
            PatternBasedInjectionHelper.dumpTypeParametersArray(owner, wildcardType.getLowerBounds(), sb, " super ", "", classes);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type raw = parameterizedType.getRawType();
            PatternBasedInjectionHelper.dumpType(null, raw, sb, classes);
            PatternBasedInjectionHelper.dumpTypeParametersArray(owner, parameterizedType.getActualTypeArguments(), sb, "<", ">", classes);
        } else if (type instanceof GenericArrayType) {
            PatternBasedInjectionHelper.dumpType(owner, ((GenericArrayType)type).getGenericComponentType(), sb, classes);
            sb.append("[]");
        }
    }

    private static void dumpTypeParametersArray(GenericDeclaration owner, Type[] typeVariables, StringBuilder sb, String prefix, String suffix, Map<Class, Collection<Class>> classes) {
        int typeVarIdx = 1;
        for (Type typeVariable : typeVariables) {
            if (typeVariable == Object.class) continue;
            if (typeVarIdx++ == 1) {
                sb.append(prefix);
            } else {
                sb.append(", ");
            }
            PatternBasedInjectionHelper.dumpType(owner, typeVariable, sb, classes);
        }
        if (typeVarIdx > 1) {
            sb.append(suffix);
        }
    }

    private static void printMethodDeclaration(Method method, StringBuilder sb, Map<Class, Collection<Class>> classes) {
        if (Modifier.isStatic(method.getModifiers())) {
            sb.append("static ");
        }
        PatternBasedInjectionHelper.dumpTypeParametersArray(method, method.getTypeParameters(), sb, "<", "> ", classes);
        PatternBasedInjectionHelper.dumpType(null, method.getGenericReturnType(), sb, classes);
        sb.append(" ").append(method.getName()).append("(");
        int paramIdx = 1;
        for (Type parameter : method.getGenericParameterTypes()) {
            if (paramIdx != 1) {
                sb.append(", ");
            }
            PatternBasedInjectionHelper.dumpType(null, parameter, sb, classes);
            sb.append(" ").append("p").append(paramIdx++);
        }
        sb.append(")");
        if (!method.getDeclaringClass().isInterface()) {
            sb.append("{}");
        }
        sb.append("\n");
    }

    private static class Frame {
        State state = State.init;
        Object target;
        String methodName;
        ArrayList<Object> params = new ArrayList();

        private Frame() {
        }
    }

    private static enum State {
        init,
        name,
        name_end,
        param_start,
        param_end,
        literal,
        invoke,
        invoke_end;

    }
}

