/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.theoryinpractice.testng.ui.Printable;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestProxy
implements AbstractTestProxy {
    private final List<TestProxy> results = new ArrayList<TestProxy>();
    private TestResultMessage resultMessage;
    private String name;
    private TestProxy parent;
    private List<Printable> output;
    private SmartPsiElementPointer psiElement;
    private boolean inProgress;
    private int myExceptionMark;

    public TestProxy() {
    }

    public TestProxy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.psiElement != null ? this.psiElement.getElement() : null;
    }

    public void setPsiElement(PsiElement psiElement) {
        if (psiElement != null) {
            Project project = psiElement.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            this.psiElement = SmartPointerManager.getInstance((Project)project).createLazyPointer(psiElement);
        } else {
            this.psiElement = null;
        }
    }

    public boolean isResult() {
        return this.resultMessage != null;
    }

    public List<AbstractTestProxy> getResults(Filter filter) {
        return filter.select(this.results);
    }

    public List<Printable> getOutput() {
        if (this.output != null) {
            return this.output;
        }
        ArrayList<Printable> total = new ArrayList<Printable>();
        for (TestProxy child : this.results) {
            List<Printable> out = child.getOutput();
            if (total.size() > 0 && out.size() > 0) {
                total.add(new TestNGConsoleView.Chunk("\n===============================================\n\n", ConsoleViewContentType.NORMAL_OUTPUT));
            }
            total.addAll(out);
        }
        return total;
    }

    public List<TestProxy> getChildren() {
        return this.results;
    }

    public TestResultMessage getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(final TestResultMessage resultMessage) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = (PsiClass)TestProxy.this.getParent().getPsiElement();
                if (psiClass != null) {
                    PsiMethod[] methods;
                    for (PsiMethod method : methods = psiClass.getAllMethods()) {
                        if (!method.getName().equals(resultMessage.getMethod())) continue;
                        TestProxy.this.setPsiElement((PsiElement)method);
                        break;
                    }
                }
            }
        });
        for (TestProxy current = this; current != null; current = current.getParent()) {
            current.inProgress = resultMessage.getResult() == 1016;
        }
        if (this.resultMessage == null || this.resultMessage.getResult() == 1016) {
            this.resultMessage = resultMessage;
            this.name = resultMessage.toDisplayString();
        }
    }

    public boolean isInProgress() {
        TestProxy parentProxy = this.getParent();
        return (parentProxy == null || parentProxy.isInProgress()) && this.inProgress;
    }

    public boolean isDefect() {
        return this.isNotPassed();
    }

    public boolean shouldRun() {
        return true;
    }

    public int getMagnitude() {
        return -1;
    }

    public boolean isLeaf() {
        return this.isResult();
    }

    public boolean isPassed() {
        return !this.isNotPassed();
    }

    public Location getLocation(Project project) {
        if (this.psiElement == null) {
            return null;
        }
        PsiElement element = this.psiElement.getElement();
        if (element == null) {
            return null;
        }
        return new PsiLocation(project, element);
    }

    public Navigatable getDescriptor(Location location) {
        PsiLocation psiLocation;
        PsiClass containingClass;
        if (location == null) {
            return null;
        }
        if (this.isNotPassed() && this.output != null && (containingClass = (PsiClass)(psiLocation = location.toPsiLocation()).getParentElement(PsiClass.class)) != null) {
            String containingMethod = null;
            Iterator iterator = psiLocation.getAncestors(PsiMethod.class, false);
            while (iterator.hasNext()) {
                PsiMethod psiMethod = (PsiMethod)((Location)iterator.next()).getPsiElement();
                if (!containingClass.equals(psiMethod.getContainingClass())) continue;
                containingMethod = psiMethod.getName();
            }
            if (containingMethod != null) {
                String qualifiedName = containingClass.getQualifiedName();
                for (Printable aStackTrace : this.output) {
                    String[] stackTrace;
                    if (!(aStackTrace instanceof TestNGConsoleView.Chunk)) continue;
                    for (String line : stackTrace = new LineTokenizer(((TestNGConsoleView.Chunk)aStackTrace).text).execute()) {
                        StackTraceLine stackLine = new StackTraceLine(containingClass.getProject(), line);
                        if (!containingMethod.equals(stackLine.getMethodName()) || !Comparing.strEqual((String)qualifiedName, (String)stackLine.getClassName())) continue;
                        return stackLine.getOpenFileDescriptor(containingClass.getContainingFile().getVirtualFile());
                    }
                }
            }
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public TestProxy[] getPathFromRoot() {
        ArrayList<TestProxy> arraylist = new ArrayList<TestProxy>();
        TestProxy testproxy = this;
        do {
            arraylist.add(testproxy);
        } while ((testproxy = testproxy.getParent()) != null);
        Collections.reverse(arraylist);
        return arraylist.toArray(new TestProxy[arraylist.size()]);
    }

    public String toString() {
        return this.name + ' ' + this.results;
    }

    public void addResult(TestProxy proxy) {
        this.results.add(proxy);
        proxy.setParent(this);
    }

    public void setParent(TestProxy parent) {
        this.parent = parent;
    }

    public TestProxy getParent() {
        return this.parent;
    }

    public void setOutput(List<Printable> output) {
        this.output = output;
    }

    public boolean isNotPassed() {
        if (this.resultNotPassed()) {
            return true;
        }
        if (this.resultMessage == null && this.results.size() == 0) {
            return true;
        }
        for (TestProxy child : this.results) {
            if (!child.isNotPassed()) continue;
            return true;
        }
        return false;
    }

    private boolean resultNotPassed() {
        return this.resultMessage != null && this.resultMessage.getResult() != 1001;
    }

    public List<TestProxy> getAllTests() {
        ArrayList<TestProxy> total = new ArrayList<TestProxy>();
        total.add(this);
        for (TestProxy child : this.results) {
            total.addAll(child.getAllTests());
        }
        return total;
    }

    public int getChildCount() {
        return this.results.size();
    }

    public TestProxy getChildAt(int i) {
        return this.results.get(i);
    }

    public TestProxy getFirstDefect() {
        for (TestProxy child : this.results) {
            if (child.isNotPassed() && child.isResult()) {
                return child;
            }
            TestProxy firstDefect = child.getFirstDefect();
            if (firstDefect == null) continue;
            return firstDefect;
        }
        return null;
    }

    public boolean childExists(String child) {
        for (int count = 0; count < this.getChildCount(); ++count) {
            if (!child.equals(this.getChildAt(count).getName())) continue;
            return true;
        }
        return false;
    }

    public int getExceptionMark() {
        if (this.myExceptionMark == 0 && this.getChildCount() > 0) {
            return (this.output != null ? this.output.size() : 0) + this.getChildAt(0).getExceptionMark();
        }
        return this.myExceptionMark;
    }

    public void setExceptionMark(int exceptionMark) {
        this.myExceptionMark = exceptionMark;
    }

    public boolean isInterrupted() {
        return !this.isInProgress() && this.inProgress;
    }
}

