/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nullable;

public class TestNGSuiteConfigurationProducer
extends TestNGConfigurationProducer {
    private PsiElement myPsiElement = null;

    public PsiElement getSourceElement() {
        return this.myPsiElement;
    }

    @Nullable
    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        PsiElement element = location.getPsiElement();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        if (!TestNGUtil.isTestngXML(virtualFile)) {
            return null;
        }
        this.myPsiElement = containingFile;
        Project project = location.getProject();
        RunnerAndConfigurationSettingsImpl settings = this.cloneTemplateConfiguration(project, context);
        TestNGConfiguration configuration = (TestNGConfiguration)settings.getConfiguration();
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.getPersistantData().SUITE_NAME = virtualFile.getPath();
        configuration.getPersistantData().TEST_OBJECT = TestType.SUITE.getType();
        configuration.restoreOriginalModule(originalModule);
        settings.setName(configuration.getName());
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        RunConfigurationExtension.patchCreatedConfiguration((ModuleBasedConfiguration)configuration);
        return settings;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

