/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class AcceptWordAsCorrect
implements SpellCheckerQuickFix {
    private ProblemDescriptor myProblemDescriptor;

    @NotNull
    public String getName() {
        String string = this.myProblemDescriptor != null ? SpellCheckerBundle.message("add.0.to.dictionary", ProblemDescriptionNode.extractHighlightedText((CommonProblemDescriptor)this.myProblemDescriptor, (PsiElement)this.myProblemDescriptor.getPsiElement())) : SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("spelling", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.LAST;
        if (anchor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect.getPopupActionAnchor must not return null");
        }
        return anchor;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect.applyFix must not be null");
        }
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.getInstance(project);
        String w = ProblemDescriptionNode.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement());
        spellCheckerManager.acceptWordAsCorrect(w);
    }

    public Icon getIcon(int flags) {
        return new ImageIcon(ShowSuggestions.class.getResource("spellcheck.png"));
    }

    @Override
    public void setDescriptor(ProblemDescriptor problemDescriptor) {
        this.myProblemDescriptor = problemDescriptor;
    }
}

