/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierSplitter
extends BaseSplitter {
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\b\\p{L}*'?\\p{L}*");
    @NonNls
    private static final Pattern WORD_EXT = Pattern.compile("(\\p{L}*?)[-_$\\[\\]0-9]");
    @NonNls
    private static final Pattern WORD_IN_QUOTES = Pattern.compile("'([^']*)'");

    @Override
    @Nullable
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.split must not be null");
        }
        if (text == null || range.getLength() < 1) {
            return null;
        }
        List<TextRange> extracted = this.excludeByPattern(text, range, WORD_IN_QUOTES, 1);
        if (extracted == null) {
            return null;
        }
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        for (TextRange textRange : extracted) {
            List<TextRange> words = IdentifierSplitter.splitByCase(text, textRange);
            if (words == null || words.size() == 0) continue;
            if (words.size() == 1) {
                IdentifierSplitter.addWord(text, results, false, words.get(0));
                continue;
            }
            boolean isCapitalized = Strings.isCapitalized(text, words.get(0));
            boolean containsShortWord = IdentifierSplitter.containsShortWord(words);
            if (isCapitalized && containsShortWord) continue;
            boolean isAllWordsAreUpperCased = IdentifierSplitter.isAllWordsAreUpperCased(text, words);
            for (TextRange word : words) {
                boolean flag;
                boolean uc = Strings.isUpperCased(text, word);
                boolean bl = flag = uc && !isAllWordsAreUpperCased;
                Matcher matcher = WORD.matcher(text.substring(word.getStartOffset(), word.getEndOffset()));
                if (!matcher.find()) continue;
                TextRange found = IdentifierSplitter.matcherRange(word, matcher);
                IdentifierSplitter.addWord(text, results, flag, found);
            }
        }
        return results;
    }

    public static List<TextRange> splitByCase(@NotNull String text, @NotNull TextRange range) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.splitByCase must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.splitByCase must not be null");
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        Matcher matcher = WORD_EXT.matcher(text.substring(range.getStartOffset(), range.getEndOffset()));
        int from = range.getStartOffset();
        while (matcher.find()) {
            TextRange found = IdentifierSplitter.matcherRange(range, matcher);
            TextRange foundWord = IdentifierSplitter.matcherRange(range, matcher, 1);
            if (!IdentifierSplitter.tooSmall(from, foundWord.getEndOffset())) {
                Strings.addAll(text, foundWord, result);
            }
            from = found.getEndOffset();
        }
        if (!IdentifierSplitter.tooSmall(from, range.getEndOffset())) {
            Strings.addAll(text, new TextRange(from, range.getEndOffset()), result);
        }
        return result;
    }
}

