/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.actions;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpellingPopupActionGroup
extends ActionGroup {
    public SpellingPopupActionGroup() {
    }

    public SpellingPopupActionGroup(String shortName, boolean popup) {
        super(shortName, popup);
    }

    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e != null) {
            AnAction[] children = SpellingPopupActionGroup.findActions(e);
            if (children.length == 0) {
                e.getPresentation().setEnabled(false);
            }
            return children;
        }
        return AnAction.EMPTY_ARRAY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static AnAction[] findActions(@NotNull AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/actions/SpellingPopupActionGroup.findActions must not be null");
        }
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        Project project = (Project)e.getData(LangDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(LangDataKeys.EDITOR);
        if (psiFile != null && project != null && editor != null) {
            List quickFixes = QuickFixAction.getAvailableActions((Editor)editor, (PsiFile)psiFile, (int)-1);
            HashMap<Anchor, List<AnAction>> children = new HashMap<Anchor, List<AnAction>>();
            ArrayList<Object> first = new ArrayList<Object>();
            children.put(Anchor.FIRST, first);
            ArrayList last = new ArrayList();
            children.put(Anchor.LAST, last);
            SpellingPopupActionGroup.extractActions(quickFixes, children);
            if (first.size() > 0 && last.size() > 0) {
                first.add(new Separator());
            }
            first.addAll(last);
            if (first.size() > 0) {
                anActionArray = first.toArray(new AnAction[first.size()]);
                if (anActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/actions/SpellingPopupActionGroup.findActions must not return null");
                return anActionArray;
            }
        }
        anActionArray = AnAction.EMPTY_ARRAY;
        if (AnAction.EMPTY_ARRAY != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/actions/SpellingPopupActionGroup.findActions must not return null");
    }

    private static void extractActions(List<HighlightInfo.IntentionActionDescriptor> descriptors, Map<Anchor, List<AnAction>> actions) {
        for (HighlightInfo.IntentionActionDescriptor actionDescriptor : descriptors) {
            QuickFixWrapper wrapper;
            LocalQuickFix localQuickFix;
            IntentionAction action = actionDescriptor.getAction();
            if (!(action instanceof QuickFixWrapper) || !((localQuickFix = (wrapper = (QuickFixWrapper)action).getFix()) instanceof SpellCheckerQuickFix)) continue;
            SpellCheckerQuickFix spellCheckerQuickFix = (SpellCheckerQuickFix)localQuickFix;
            Anchor anchor = spellCheckerQuickFix.getPopupActionAnchor();
            SpellCheckerIntentionAction popupAction = new SpellCheckerIntentionAction(action);
            List<AnAction> list = actions.get(anchor);
            if (list == null) continue;
            list.add(popupAction);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (e != null && e.getPresentation().isVisible() && SpellingPopupActionGroup.findActions(e).length == 0) {
            e.getPresentation().setVisible(false);
        }
    }

    private static class SpellCheckerIntentionAction
    extends AnAction {
        private static final Logger LOGGER = Logger.getInstance((String)"#SpellCheckerAction");
        private final IntentionAction intention;

        public SpellCheckerIntentionAction(IntentionAction intention) {
            super(intention.getText());
            this.intention = intention;
        }

        public void actionPerformed(final AnActionEvent e) {
            final PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
            final Project project = (Project)e.getData(LangDataKeys.PROJECT);
            final Editor editor = (Editor)e.getData(LangDataKeys.EDITOR);
            if (psiFile != null && project != null && editor != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    SpellCheckerIntentionAction.this.intention.invoke(project, editor, psiFile);
                                }
                                catch (IncorrectOperationException ex) {
                                    LOGGER.error((Throwable)ex);
                                }
                            }
                        }, e.getPresentation().getText(), (Object)e.getActionManager().getId((AnAction)SpellCheckerIntentionAction.this));
                    }
                });
            }
        }
    }
}

