/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;

public class PropertyReferenceViaLastWordSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer) {
        final PsiElement refElement = queryParameters.getElementToSearch();
        if (refElement instanceof Property) {
            TextOccurenceProcessor processor;
            PsiSearchHelper helper;
            String name = ((Property)refElement).getName();
            if (name == null) {
                return true;
            }
            List words = StringUtil.getWordsIn((String)name);
            if (words.isEmpty()) {
                return true;
            }
            String lastWord = (String)words.get(words.size() - 1);
            SearchScope searchScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                public SearchScope compute() {
                    return queryParameters.getEffectiveSearchScope();
                }
            });
            if (searchScope instanceof GlobalSearchScope) {
                searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX});
            }
            if (!(helper = PsiManager.getInstance((Project)refElement.getProject()).getSearchHelper()).processElementsWithWord(processor = new TextOccurenceProcessor(){

                public boolean execute(PsiElement element, int offsetInElement) {
                    PsiReference[] refs;
                    ProgressManager.checkCanceled();
                    for (PsiReference ref : refs = element.getReferences()) {
                        if (ref.getRangeInElement().contains(offsetInElement) && ref.isReferenceTo(refElement)) {
                            return consumer.process((Object)ref);
                        }
                        ProgressManager.checkCanceled();
                    }
                    return true;
                }
            }, searchScope, lastWord, (short)8, false)) {
                return false;
            }
        }
        return true;
    }
}

