/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.NoPropertySelectedPanel;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewComponent;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.editor.ResourceBundleEditor");
    private JPanel myPanel;
    private JPanel myValuesPanel;
    private JPanel myStructureViewPanel;
    private JPanel mySplitParent;
    private final StructureViewComponent myStructureViewComponent;
    private final Map<PropertiesFile, Editor> myEditors;
    private final ResourceBundle myResourceBundle;
    private final Map<PropertiesFile, JPanel> myTitledPanels;
    private final JComponent myNoPropertySelectedPanel;
    private final Map<Editor, DocumentListener> myDocumentListeners;
    private final Project myProject;
    private boolean myDisposed;
    private final DataProviderPanel myDataProviderPanel;
    private final Set<PropertiesFile> myBackSlashPressed;
    @NonNls
    private static final String VALUES = "values";
    @NonNls
    private static final String NO_PROPERTY_SELECTED = "noPropertySelected";
    private PsiTreeChangeAdapter myPsiTreeChangeAdapter;
    @NonNls
    protected static final String PROPORTION_PROPERTY = "RESOURCE_BUNDLE_SPLITTER_PROPORTION";
    private Editor mySelectedEditor;
    private final Alarm myUpdateEditorAlarm;
    private final Alarm myUpdatePsiAlarm;

    public ResourceBundleEditor(Project project, ResourceBundle resourceBundle) {
        this.$$$setupUI$$$();
        this.myNoPropertySelectedPanel = new NoPropertySelectedPanel().getComponent();
        this.myDocumentListeners = new THashMap();
        this.myBackSlashPressed = new THashSet();
        this.myUpdateEditorAlarm = new Alarm();
        this.myUpdatePsiAlarm = new Alarm();
        this.myProject = project;
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        this.myResourceBundle = resourceBundle;
        this.myStructureViewComponent = new ResourceBundleStructureViewComponent(project, this.myResourceBundle, this);
        this.myStructureViewPanel.setLayout(new BorderLayout());
        this.myStructureViewPanel.add((Component)this.myStructureViewComponent, "Center");
        this.myStructureViewComponent.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private String selectedPropertyName;
            private PropertiesFile selectedPropertiesFile;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ResourceBundleEditor.this.getSelectedPropertyName() == null) {
                    return;
                }
                if (!Comparing.strEqual((String)this.selectedPropertyName, (String)ResourceBundleEditor.this.getSelectedPropertyName()) || !Comparing.equal((Object)this.selectedPropertiesFile, (Object)ResourceBundleEditor.this.getSelectedPropertiesFile())) {
                    this.selectedPropertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                    this.selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    ResourceBundleEditor.this.selectionChanged();
                }
            }
        });
        this.installPropertiesChangeListeners();
        this.myEditors = new THashMap();
        this.myTitledPanels = new THashMap();
        this.recreateEditorsPanel();
        TreeElement[] children = this.myStructureViewComponent.getTreeModel().getRoot().getChildren();
        if (children.length != 0) {
            TreeElement child = children[0];
            String propName = ((ResourceBundlePropertyStructureViewElement)child).getValue();
            this.setState(new ResourceBundleEditorState(propName));
        }
        this.myDataProviderPanel = new DataProviderPanel(this.myPanel);
    }

    private void recreateEditorsPanel() {
        this.myUpdateEditorAlarm.cancelAllRequests();
        this.myValuesPanel.removeAll();
        this.myValuesPanel.setLayout(new CardLayout());
        if (!this.myProject.isOpen()) {
            return;
        }
        MyJPanel valuesPanelComponent = new MyJPanel(new GridBagLayout());
        this.myValuesPanel.add((Component)new JScrollPane(valuesPanelComponent){

            @Override
            public void updateUI() {
                super.updateUI();
                this.getViewport().setBackground(UIManager.getColor("Panel.background"));
            }
        }, VALUES);
        this.myValuesPanel.add((Component)this.myNoPropertySelectedPanel, NO_PROPERTY_SELECTED);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.releaseAllEditors();
        this.myTitledPanels.clear();
        int y = 0;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            final Editor editor = ResourceBundleEditor.createEditor();
            this.myEditors.put(propertiesFile, editor);
            editor.getContentComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ResourceBundleEditor.this.mySelectedEditor = editor;
                }
            });
            gc.gridx = 0;
            gc.gridy = y++;
            gc.gridheight = 1;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.anchor = 10;
            Locale locale = propertiesFile.getLocale();
            ArrayList<String> names = new ArrayList<String>();
            if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
                names.add(locale.getDisplayLanguage());
            }
            if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
                names.add(locale.getDisplayCountry());
            }
            if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
                names.add(locale.getDisplayVariant());
            }
            String title = propertiesFile.getName();
            if (!names.isEmpty()) {
                title = title + " (" + StringUtil.join(names, (String)"/") + ")";
            }
            JPanel comp = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Insets insets = this.getBorder().getBorderInsets(this);
                    return new Dimension(100, editor.getLineHeight() * 4 + insets.top + insets.bottom);
                }
            };
            comp.add((Component)editor.getComponent(), "Center");
            comp.setBorder(IdeBorderFactory.createTitledBorder((String)title));
            this.myTitledPanels.put(propertiesFile, comp);
            valuesPanelComponent.add((Component)comp, gc);
        }
        gc.gridx = 0;
        gc.gridy = y;
        gc.gridheight = 0;
        gc.gridwidth = 0;
        gc.weightx = 10.0;
        gc.weighty = 1.0;
        valuesPanelComponent.add((Component)new JPanel(), gc);
        this.myValuesPanel.repaint();
    }

    private void installPropertiesChangeListeners() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                if (event.getFile().getFileType() == PropertiesFileType.FILE_TYPE) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void fileDeleted(VirtualFileEvent event) {
                if (event.getFile().getFileType() == PropertiesFileType.FILE_TYPE) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void propertyChanged(VirtualFilePropertyEvent event) {
                if (event.getFile().getFileType() == PropertiesFileType.FILE_TYPE) {
                    if ("name".equals(event.getPropertyName())) {
                        ResourceBundleEditor.this.recreateEditorsPanel();
                    } else {
                        ResourceBundleEditor.this.updateEditorsFromProperties();
                    }
                }
            }
        }, (Disposable)this);
        this.myPsiTreeChangeAdapter = new PsiTreeChangeAdapter(){

            public void childAdded(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childMoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childrenChanged(PsiTreeChangeEvent event) {
                PsiFile file = event.getFile();
                if (!(file instanceof PropertiesFile)) {
                    return;
                }
                if (!((PropertiesFile)file).getResourceBundle().equals(ResourceBundleEditor.this.myResourceBundle)) {
                    return;
                }
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter, (Disposable)this);
    }

    private void selectionChanged() {
        this.myBackSlashPressed.clear();
        this.updateEditorsFromProperties();
    }

    private void updateEditorsFromProperties() {
        this.myUpdateEditorAlarm.cancelAllRequests();
        this.myUpdateEditorAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ResourceBundleEditor.this.isValid()) {
                    return;
                }
                if (ResourceBundleEditor.this.myUpdatePsiAlarm.getActiveRequestCount() != 0) {
                    ResourceBundleEditor.this.myUpdateEditorAlarm.cancelAllRequests();
                    ResourceBundleEditor.this.myUpdateEditorAlarm.addRequest((Runnable)this, 200);
                    return;
                }
                ResourceBundleEditor.this.uninstallDocumentListeners();
                try {
                    String propertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                    ((CardLayout)ResourceBundleEditor.this.myValuesPanel.getLayout()).show(ResourceBundleEditor.this.myValuesPanel, propertyName == null ? ResourceBundleEditor.NO_PROPERTY_SELECTED : ResourceBundleEditor.VALUES);
                    if (propertyName == null) {
                        return;
                    }
                    List<PropertiesFile> propertiesFiles = ResourceBundleEditor.this.myResourceBundle.getPropertiesFiles(ResourceBundleEditor.this.myProject);
                    for (final PropertiesFile propertiesFile : propertiesFiles) {
                        EditorEx editor = (EditorEx)ResourceBundleEditor.this.myEditors.get(propertiesFile);
                        if (editor == null) continue;
                        ResourceBundleEditor.reinitSettings(editor);
                        Property property = propertiesFile.findPropertyByKey(propertyName);
                        final String value = property == null ? "" : property.getValue();
                        final Document document = editor.getDocument();
                        CommandProcessor.getInstance().executeCommand(null, new Runnable(){

                            @Override
                            public void run() {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        ResourceBundleEditor.this.updateDocumentFromPropertyValue(value, document, propertiesFile);
                                    }
                                });
                            }
                        }, "", (Object)this);
                        JPanel titledPanel = (JPanel)ResourceBundleEditor.this.myTitledPanels.get(propertiesFile);
                        ((TitledBorder)titledPanel.getBorder()).setTitleColor(property == null ? Color.red : UIUtil.getLabelTextForeground());
                        titledPanel.repaint();
                    }
                }
                finally {
                    ResourceBundleEditor.this.installDocumentListeners();
                }
            }
        }, 200);
    }

    private void updateDocumentFromPropertyValue(String value, Document document, PropertiesFile propertiesFile) {
        String text = value;
        if (this.myBackSlashPressed.contains(propertiesFile)) {
            text = text + "\\";
        }
        document.replaceString(0, document.getTextLength(), (CharSequence)text);
    }

    private void updatePropertyValueFromDocument(String propertyName, Project project, PropertiesFile propertiesFile, String text) {
        if (PropertiesUtil.isUnescapedBackSlashAtTheEnd(text)) {
            this.myBackSlashPressed.add(propertiesFile);
        } else {
            this.myBackSlashPressed.remove(propertiesFile);
        }
        String value = ResourceBundleEditor.getPropertyValueFromText(text);
        Property property = propertiesFile.findPropertyByKey(propertyName);
        try {
            if (property == null) {
                property = PropertiesElementFactory.createProperty(project, propertyName, value);
                propertiesFile.addProperty(property);
            } else {
                property.setValue(value);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String getPropertyValueFromText(String text) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!PropertiesUtil.isUnescapedBackSlashAtTheEnd(value.toString())) {
                    value.append("\\");
                }
                value.append("\n");
                continue;
            }
            value.append(c);
        }
        return value.toString();
    }

    private void installDocumentListeners() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        for (final PropertiesFile propertiesFile : propertiesFiles) {
            EditorEx editor = (EditorEx)this.myEditors.get(propertiesFile);
            if (editor == null) continue;
            DocumentAdapter listener = new DocumentAdapter(){
                private String oldText;

                public void beforeDocumentChange(DocumentEvent e) {
                    this.oldText = e.getDocument().getText();
                }

                public void documentChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    String text = document.getText();
                    ResourceBundleEditor.this.updatePropertyValueFor(document, propertiesFile, text, this.oldText);
                }
            };
            this.myDocumentListeners.put((Editor)editor, (DocumentListener)listener);
            editor.getDocument().addDocumentListener((DocumentListener)listener);
        }
    }

    private void uninstallDocumentListeners() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            Editor editor = this.myEditors.get(propertiesFile);
            DocumentListener listener = this.myDocumentListeners.remove(editor);
            if (listener == null) continue;
            editor.getDocument().removeDocumentListener(listener);
        }
    }

    private void updatePropertyValueFor(final Document document, final PropertiesFile propertiesFile, final String text, final String oldText) {
        this.myUpdatePsiAlarm.cancelAllRequests();
        this.myUpdatePsiAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!ResourceBundleEditor.this.isValid()) {
                    return;
                }
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Project project = propertiesFile.getProject();
                                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                                documentManager.commitDocument(document);
                                Document propertiesFileDocument = documentManager.getDocument((PsiFile)propertiesFile);
                                documentManager.commitDocument(propertiesFileDocument);
                                if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
                                    ResourceBundleEditor.this.uninstallDocumentListeners();
                                    try {
                                        document.replaceString(0, document.getTextLength(), (CharSequence)oldText);
                                    }
                                    finally {
                                        ResourceBundleEditor.this.installDocumentListeners();
                                    }
                                    return;
                                }
                                String propertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                                if (propertyName == null) {
                                    return;
                                }
                                ResourceBundleEditor.this.updatePropertyValueFromDocument(propertyName, project, propertiesFile, text);
                            }
                        });
                    }
                });
            }
        }, 300, ModalityState.stateForComponent((Component)this.getComponent()));
    }

    @Nullable
    private String getSelectedPropertyName() {
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return null;
        }
        TreePath selected = tree.getSelectionModel().getSelectionPath();
        if (selected == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (!(userObject instanceof AbstractTreeNode)) {
            return null;
        }
        Object value = ((AbstractTreeNode)userObject).getValue();
        return value instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)value).getValue() : null;
    }

    @NotNull
    public JComponent getComponent() {
        DataProviderPanel dataProviderPanel = this.myDataProviderPanel;
        if (dataProviderPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditor.getComponent must not return null");
        }
        return dataProviderPanel;
    }

    private Object getData(String dataId) {
        if (SelectInContext.DATA_KEY.is(dataId)) {
            return new SelectInContext(){

                @NotNull
                public Project getProject() {
                    Project project = ResourceBundleEditor.this.myProject;
                    if (project == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditor$10.getProject must not return null");
                    }
                    return project;
                }

                @NotNull
                public VirtualFile getVirtualFile() {
                    VirtualFile virtualFile;
                    PropertiesFile selectedFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
                    assert (virtualFile != null);
                    VirtualFile virtualFile3 = virtualFile;
                    if (virtualFile3 == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditor$10.getVirtualFile must not return null");
                    }
                    return virtualFile3;
                }

                public Object getSelectorInFile() {
                    return ResourceBundleEditor.this.getSelectedPropertiesFile();
                }

                public FileEditorProvider getFileEditorProvider() {
                    final PropertiesFile selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    if (selectedPropertiesFile == null) {
                        return null;
                    }
                    return new FileEditorProvider(){

                        public FileEditor openFileEditor() {
                            VirtualFile file = selectedPropertiesFile.getVirtualFile();
                            if (file == null) {
                                return null;
                            }
                            return FileEditorManager.getInstance((Project)this.getProject()).openFile(file, false)[0];
                        }
                    };
                }
            };
        }
        return null;
    }

    private PropertiesFile getSelectedPropertiesFile() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        PropertiesFile selectedFile = null;
        for (PropertiesFile file : this.myEditors.keySet()) {
            Editor editor = this.myEditors.get(file);
            if (editor != this.mySelectedEditor) continue;
            selectedFile = file;
            break;
        }
        return selectedFile;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStructureViewPanel;
    }

    @NotNull
    public String getName() {
        if ("Resource Bundle" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditor.getName must not return null");
        }
        return "Resource Bundle";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditor.getState must not be null");
        }
        ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditorState(this.getSelectedPropertyName());
        if (resourceBundleEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditor.getState must not return null");
        }
        return resourceBundleEditorState;
    }

    private Splitter getSplitter() {
        return (Splitter)this.mySplitParent.getComponents()[0];
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditor.setState must not be null");
        }
        ResourceBundleEditorState myState = (ResourceBundleEditorState)state;
        String propertyName = myState.myPropertyName;
        if (propertyName != null) {
            this.myStructureViewComponent.select((Object)propertyName, true);
            this.selectionChanged();
        }
        float proportion = 0.5f;
        try {
            String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(PROPORTION_PROPERTY);
            if (value != null) {
                proportion = Float.parseFloat(value);
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        final float proportion1 = proportion;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.getSplitter().setProportion(proportion1);
            }
        });
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myProject.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditor.addPropertyChangeListener must not be null");
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditor.removePropertyChangeListener must not be null");
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        float proportion = this.getSplitter().getProportion();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPORTION_PROPERTY, Double.toString(proportion));
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myStructureViewComponent);
        this.releaseAllEditors();
    }

    private void releaseAllEditors() {
        for (Editor editor : this.myEditors.values()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
        this.myEditors.clear();
    }

    private static Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(document);
        ResourceBundleEditor.reinitSettings(editor);
        return editor;
    }

    private static void reinitSettings(EditorEx editor) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PropertiesValueHighlighter(), scheme));
        editor.setVerticalScrollbarVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitParent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), 5, 5, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(347);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myStructureViewPanel = jPanel2 = new JPanel();
        jSplitPane.setLeftComponent(jPanel2);
        this.myValuesPanel = jPanel = new JPanel();
        jSplitPane.setRightComponent(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyJPanel
    extends JPanel
    implements Scrollable {
        private MyJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Editor editor = (Editor)ResourceBundleEditor.this.myEditors.values().iterator().next();
            return editor.getLineHeight() * 4;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private DataProviderPanel(JPanel panel) {
            super(new BorderLayout());
            this.add((Component)panel, "Center");
        }

        @Nullable
        public Object getData(String dataId) {
            return ResourceBundleEditor.this.getData(dataId);
        }
    }

    public static class ResourceBundleEditorState
    implements FileEditorState {
        private final String myPropertyName;

        public ResourceBundleEditorState(String propertyName) {
            this.myPropertyName = propertyName;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }
    }
}

