/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.TestRoot;
import com.intellij.execution.junit2.info.ClassBasedInfo;
import com.intellij.execution.junit2.info.DisplayTestInfoExtractor;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.util.containers.HashMap;
import java.util.List;

public class TestRootImpl
implements TestRoot {
    private final TestProxy myRootTest;
    private final HashMap<String, TestProxy> myKnownDynamicParents = new HashMap();

    public TestRootImpl(TestProxy rootTest) {
        this.myRootTest = rootTest;
    }

    @Override
    public void addChild(TestProxy child) {
        if (child == this.myRootTest) {
            return;
        }
        this.getDynamicParentFor(child).addChild(child);
    }

    private TestProxy getDynamicParentFor(TestProxy child) {
        String parentClass = child.getInfo().getComment();
        TestProxy dynamicParent = (TestProxy)((Object)this.myKnownDynamicParents.get((Object)parentClass));
        if (dynamicParent == null) {
            dynamicParent = new TestProxy(new DynamicParentInfo(parentClass));
            this.myKnownDynamicParents.put((Object)parentClass, (Object)dynamicParent);
            this.myRootTest.addChild(dynamicParent);
        }
        return dynamicParent;
    }

    public TestProxy getRootTest() {
        return this.myRootTest;
    }

    @Override
    public List<TestProxy> getAllTests() {
        return this.getRootTest().getAllTests();
    }

    private static class DynamicParentInfo
    extends ClassBasedInfo {
        public DynamicParentInfo(String className) {
            super(DisplayTestInfoExtractor.FOR_CLASS);
            this.setClassName(className);
        }

        @Override
        public void readFrom(ObjectReader reader) {
        }
    }
}

