/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;

class TestClass
extends TestObject {
    public TestClass(Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        super(project, configuration, runnerSettings, configurationSettings);
    }

    @Override
    protected void initialize() throws ExecutionException {
        super.initialize();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        RunConfigurationModule module = this.myConfiguration.getConfigurationModule();
        this.configureModule(this.myJavaParameters, module, data.getMainClassName());
        Project project = module.getProject();
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)data.getMainClassName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        if (JUnitUtil.isJUnit4TestClass((PsiClass)psiClass)) {
            this.myJavaParameters.getProgramParametersList().add("-junit4");
        }
        this.myJavaParameters.getProgramParametersList().add(data.getMainClassName());
    }

    @Override
    public String suggestActionName() {
        return ExecutionUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.myConfiguration.getPersistentData().MAIN_CLASS_NAME), (int)0);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myClass);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiElement element) {
        PsiClass aClass = JUnitUtil.getTestClass((PsiElement)element);
        if (aClass == null) {
            return false;
        }
        PsiMethod method = JUnitUtil.getTestMethod((PsiElement)element);
        if (method != null) {
            return false;
        }
        return Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)configuration.getPersistentData().getMainClassName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String testClassName = this.myConfiguration.getPersistentData().getMainClassName();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule();
        PsiClass testClass = configurationModule.checkModuleAndClassName(testClassName, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{testClassName}));
        }
    }
}

