/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IMethodWorker;
import org.testng.internal.IWorkerFactory;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final boolean DEBUG = false;
    private static final boolean DOT_FILES = false;
    private DynamicGraph<ITestNGMethod> m_graph;
    private List<Runnable> m_activeRunnables = new ArrayList<Runnable>();
    private IWorkerFactory m_factory;
    private XmlTest m_xmlTest;
    private List<String> m_dotFiles = Lists.newArrayList();

    public GroupThreadPoolExecutor(IWorkerFactory factory, XmlTest xmlTest, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, DynamicGraph<ITestNGMethod> graph) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.m_graph = graph;
        this.m_factory = factory;
        this.m_xmlTest = xmlTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<ITestNGMethod> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            Set<ITestNGMethod> freeNodes = this.m_graph.getFreeNodes();
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(Set<ITestNGMethod> nodes) {
        List<IMethodWorker> runnables = this.m_factory.createWorkers(this.m_xmlTest, nodes);
        for (IMethodWorker r : runnables) {
            this.m_activeRunnables.add(r);
            this.setStatus(r, DynamicGraph.Status.RUNNING);
            this.ppp("Executing: " + r);
            try {
                this.execute(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IMethodWorker worker, DynamicGraph.Status status) {
        this.ppp("Set status:" + worker + " status:" + (Object)((Object)status));
        DynamicGraph<ITestNGMethod> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (ITestNGMethod m : worker.getMethods()) {
                this.m_graph.setStatus(m, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable r, Throwable t) {
        this.ppp("Finished runnable:" + r);
        this.m_activeRunnables.remove(r);
        this.setStatus((IMethodWorker)r, DynamicGraph.Status.FINISHED);
        DynamicGraph<ITestNGMethod> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            this.ppp("Node count:" + this.m_graph.getNodeCount() + " and " + this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED));
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.ppp("Shutting down executor " + this);
                this.shutdown();
            } else {
                Set<ITestNGMethod> freeNodes = this.m_graph.getFreeNodes();
                this.runNodes(freeNodes);
            }
        }
    }

    private void generateFiles(List<String> files) {
        try {
            File dir2 = File.createTempFile("TestNG-", "");
            dir2.delete();
            dir2.mkdir();
            for (int i = 0; i < files.size(); ++i) {
                File f = new File(dir2, "" + (i < 10 ? "0" : "") + i + ".dot");
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.append(files.get(i));
                bw.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void ppp(String string) {
    }
}

