/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.RawCommandLineEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginRunConfigurationEditor
extends SettingsEditor<PluginRunConfiguration> {
    private DefaultComboBoxModel myModulesModel = new DefaultComboBoxModel();
    private final JComboBox myModules = new JComboBox(this.myModulesModel);
    private final JLabel myModuleLabel = new JLabel(DevKitBundle.message("run.configuration.classpath.from.module.choose", new Object[0]));
    private final LabeledComponent<RawCommandLineEditor> myVMParameters = new LabeledComponent();
    private final LabeledComponent<RawCommandLineEditor> myProgramParameters = new LabeledComponent();
    @NonNls
    private final JCheckBox myShowLogs = new JCheckBox(DevKitBundle.message("show.smth", "idea.log"));
    private final PluginRunConfiguration myPRC;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.run.PluginRunConfigurationEditor");

    public PluginRunConfigurationEditor(final PluginRunConfiguration prc) {
        this.myPRC = prc;
        this.myShowLogs.setSelected(PluginRunConfigurationEditor.isShow(prc));
        this.myShowLogs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PluginRunConfigurationEditor.setShow(prc, PluginRunConfigurationEditor.this.myShowLogs.isSelected());
            }
        });
        this.myModules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginRunConfigurationEditor.this.myModules.getSelectedItem() != null) {
                    prc.removeAllLogFiles();
                    Sdk jdk = ModuleRootManager.getInstance((Module)((Module)PluginRunConfigurationEditor.this.myModules.getSelectedItem())).getSdk();
                    jdk = IdeaJdk.findIdeaJdk(jdk);
                    if (jdk != null) {
                        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
                        if (sandboxHome == null) {
                            return;
                        }
                        try {
                            String file = new File(sandboxHome).getCanonicalPath() + File.separator + "system" + File.separator + "log" + File.separator + "idea.log";
                            if (new File(file).exists()) {
                                prc.addLogFile(file, DevKitBundle.message("idea.log.tab.title", new Object[0]), PluginRunConfigurationEditor.this.myShowLogs.isSelected());
                            }
                        }
                        catch (IOException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                }
            }
        });
    }

    private static void setShow(PluginRunConfiguration prc, boolean show) {
        ArrayList logFiles = prc.getLogFiles();
        for (LogFileOptions logFile : logFiles) {
            logFile.setEnable(show);
        }
    }

    private static boolean isShow(PluginRunConfiguration prc) {
        ArrayList logFiles = prc.getLogFiles();
        for (LogFileOptions logFile : logFiles) {
            if (!logFile.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void resetEditorFrom(PluginRunConfiguration prc) {
        this.myModules.setSelectedItem(prc.getModule());
        this.getVMParameters().setText(prc.VM_PARAMETERS);
        this.getProgramParameters().setText(prc.PROGRAM_PARAMETERS);
    }

    public void applyEditorTo(PluginRunConfiguration prc) throws ConfigurationException {
        prc.setModule((Module)this.myModules.getSelectedItem());
        prc.VM_PARAMETERS = this.getVMParameters().getText();
        prc.PROGRAM_PARAMETERS = this.getProgramParameters().getText();
    }

    @NotNull
    public JComponent createEditor() {
        this.myModulesModel = new DefaultComboBoxModel<Module>(this.myPRC.getModules());
        this.myModules.setModel(this.myModulesModel);
        this.myModules.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, final Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText((String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return ((Module)value).getName();
                        }
                    }));
                    this.setIcon(((Module)value).getModuleType().getNodeIcon(true));
                }
                return this;
            }
        });
        JPanel wholePanel = new JPanel(new GridBagLayout());
        this.myVMParameters.setText(DevKitBundle.message("vm.parameters", new Object[0]));
        this.myVMParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myVMParameters.getComponent()).setDialogCaption(this.myVMParameters.getRawText());
        this.myProgramParameters.setText(DevKitBundle.message("program.parameters", new Object[0]));
        this.myProgramParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myProgramParameters.getComponent()).setDialogCaption(this.myProgramParameters.getRawText());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0);
        wholePanel.add((Component)this.myVMParameters, gc);
        wholePanel.add((Component)this.myProgramParameters, gc);
        wholePanel.add((Component)this.myShowLogs, gc);
        wholePanel.add((Component)this.myModuleLabel, gc);
        gc.weighty = 1.0;
        wholePanel.add((Component)this.myModules, gc);
        JPanel jPanel = wholePanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/run/PluginRunConfigurationEditor.createEditor must not return null");
        }
        return jPanel;
    }

    public RawCommandLineEditor getVMParameters() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    public RawCommandLineEditor getProgramParameters() {
        return (RawCommandLineEditor)this.myProgramParameters.getComponent();
    }

    public void disposeEditor() {
    }
}

