/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class JUnitDevKitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        String sandboxHome;
        String id;
        Sdk jdk = javaParameters.getJdk();
        if ((jdk = IdeaJdk.findIdeaJdk(jdk)) == null) {
            return;
        }
        String libPath = jdk.getHomePath() + File.separator + "lib";
        ParametersList vm = javaParameters.getVMParametersList();
        vm.add("-Xbootclasspath/a:" + libPath + File.separator + "boot.jar");
        if (!vm.hasProperty("idea.load.plugins.id") && module != null && PluginModuleType.isOfType(module) && (id = DescriptorUtil.getPluginId(module)) != null) {
            vm.defineProperty("idea.load.plugins.id", id);
        }
        if ((sandboxHome = JUnitDevKitPatcher.getSandboxPath(jdk)) != null) {
            if (!vm.hasProperty("idea.home.path")) {
                vm.defineProperty("idea.home.path", sandboxHome + File.separator + "test");
            }
            if (!vm.hasProperty("idea.plugins.path")) {
                vm.defineProperty("idea.plugins.path", sandboxHome + File.separator + "plugins");
            }
        }
        javaParameters.getClassPath().addFirst(libPath + File.separator + "idea.jar");
        javaParameters.getClassPath().addFirst(libPath + File.separator + "resources.jar");
        javaParameters.getClassPath().addFirst(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk));
    }

    @Nullable
    private static String getSandboxPath(Sdk jdk) {
        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome != null) {
            try {
                sandboxHome = new File(sandboxHome).getCanonicalPath();
            }
            catch (IOException e) {
                sandboxHome = new File(sandboxHome).getAbsolutePath();
            }
        }
        return sandboxHome;
    }
}

