/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.module.PluginModuleBuilder;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;

public class PluginModuleType
extends ModuleType<PluginModuleBuilder> {
    private static final Icon PLUGIN_MODULE_ICON = IconLoader.getIcon((String)"/modules/pluginModule.png");
    private static final Icon PLUGIN_MODULE_NODE_ICON = IconLoader.getIcon((String)"/nodes/plugin.png");
    private static final Icon ADD_PLUGIN_MODULE_ICON = IconLoader.getIcon((String)"/add_plugin_modulewizard.png");
    @NonNls
    private static final String ID = "PLUGIN_MODULE";

    public PluginModuleType() {
        super(ID);
    }

    public static PluginModuleType getInstance() {
        return (PluginModuleType)ModuleTypeManager.getInstance().findByID(ID);
    }

    public static boolean isOfType(Module module) {
        return module.getModuleType() instanceof PluginModuleType;
    }

    public ModuleWizardStep[] createWizardSteps(final WizardContext wizardContext, PluginModuleBuilder moduleBuilder, ModulesProvider modulesProvider) {
        ProjectWizardStepFactory stepFactory = ProjectWizardStepFactory.getInstance();
        ArrayList<ModuleWizardStep> steps = new ArrayList<ModuleWizardStep>();
        steps.add(stepFactory.createSourcePathsStep(wizardContext, (SourcePathsBuilder)moduleBuilder, ADD_PLUGIN_MODULE_ICON, "reference.dialogs.new.project.fromScratch.source"));
        steps.add(stepFactory.createProjectJdkStep(wizardContext, IdeaJdk.getInstance(), (JavaModuleBuilder)moduleBuilder, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Sdk projectJdk = wizardContext.getProjectJdk();
                return IdeaJdk.findIdeaJdk(projectJdk) == null ? Boolean.TRUE : Boolean.FALSE;
            }
        }, ADD_PLUGIN_MODULE_ICON, "reference.dialogs.new.project.fromScratch.sdk"));
        Object[] wizardSteps = steps.toArray(new ModuleWizardStep[steps.size()]);
        return (ModuleWizardStep[])ArrayUtil.mergeArrays((Object[])wizardSteps, (Object[])super.createWizardSteps(wizardContext, (ModuleBuilder)moduleBuilder, modulesProvider), ModuleWizardStep.class);
    }

    public PluginModuleBuilder createModuleBuilder() {
        return new PluginModuleBuilder();
    }

    public String getName() {
        return DevKitBundle.message("module.title", new Object[0]);
    }

    public String getDescription() {
        return DevKitBundle.message("module.description", new Object[0]);
    }

    public Icon getBigIcon() {
        return PLUGIN_MODULE_ICON;
    }

    public Icon getNodeIcon(boolean isOpened) {
        return PLUGIN_MODULE_NODE_ICON;
    }

    @Nullable
    public static XmlFile getPluginXml(Module module) {
        return PluginModuleType.getPluginXml(module, true);
    }

    @Nullable
    public static XmlFile getPluginXml(Module module, boolean initialize) {
        VirtualFile vFile;
        if (module == null) {
            return null;
        }
        if (!(module.getModuleType() instanceof PluginModuleType)) {
            return null;
        }
        PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
        if (buildConfiguration == null) {
            return null;
        }
        VirtualFilePointer pluginXMLPointer = initialize ? buildConfiguration.getPluginXmlPointer() : buildConfiguration.getStoredPluginXmlPointer();
        VirtualFile virtualFile = vFile = pluginXMLPointer != null ? pluginXMLPointer.getFile() : null;
        if (vFile == null) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(vFile);
        return file instanceof XmlFile ? (XmlFile)file : null;
    }

    public static boolean isPluginModuleOrDependency(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/module/PluginModuleType.isPluginModuleOrDependency must not be null");
        }
        if (PluginModuleType.isOfType(module)) {
            return true;
        }
        return PluginModuleType.getCandidateModules(module).size() > 0;
    }

    public static List<Module> getCandidateModules(Module module) {
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        Sdk jdk = manager.getSdk();
        if (IdeaJdk.findIdeaJdk(jdk) == null) {
            return Collections.emptyList();
        }
        Module[] modules = ModuleManager.getInstance((Project)module.getProject()).getModules();
        ArrayList<Module> candidates = new ArrayList<Module>(modules.length);
        HashSet deps = new HashSet(modules.length);
        for (Module m : modules) {
            if (m.getModuleType() != PluginModuleType.getInstance()) continue;
            deps.clear();
            PluginBuildUtil.getDependencies(m, (Set<Module>)deps);
            if (!deps.contains(module) || PluginModuleType.getPluginXml(m) == null) continue;
            candidates.add(m);
        }
        return candidates;
    }

    public boolean isValidSdk(Module module, Sdk projectSdk) {
        return JavaModuleType.isValidJavaSdk((Module)module);
    }
}

