/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.charset;

import com.intellij.lang.properties.charset.Native2AsciiCharsetDecoder;
import com.intellij.lang.properties.charset.Native2AsciiCharsetEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class Native2AsciiCharset
extends Charset {
    private final Charset myBaseCharset;
    private static final String NAME_PREFIX = "NATIVE_TO_ASCII_";
    private static final String DEFAULT_ENCODING_NAME = "ISO-8859-1";

    private Native2AsciiCharset(String canonicalName) {
        super(canonicalName, null);
        String baseCharsetName = canonicalName.substring(NAME_PREFIX.length());
        Charset baseCharset = null;
        try {
            baseCharset = Charset.forName(baseCharsetName);
        }
        catch (IllegalCharsetNameException e) {
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        this.myBaseCharset = baseCharset == null ? Charset.forName(DEFAULT_ENCODING_NAME) : baseCharset;
    }

    @Override
    public String displayName() {
        return this.getBaseCharset().displayName();
    }

    @Override
    public boolean contains(Charset cs) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Native2AsciiCharsetDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Native2AsciiCharsetEncoder(this);
    }

    public Charset getBaseCharset() {
        return this.myBaseCharset;
    }

    public static String makeNative2AsciiEncodingName(String baseCharsetName) {
        if (baseCharsetName == null) {
            baseCharsetName = DEFAULT_ENCODING_NAME;
        }
        return NAME_PREFIX + baseCharsetName;
    }

    public static Charset forName(String charsetName) {
        if (charsetName.startsWith(NAME_PREFIX)) {
            return new Native2AsciiCharset(charsetName);
        }
        return null;
    }

    public static Charset wrap(Charset baseCharset) {
        return new Native2AsciiCharset(NAME_PREFIX + baseCharset.name());
    }

    public static Charset nativeToBaseCharset(Charset charset) {
        if (charset instanceof Native2AsciiCharset) {
            return ((Native2AsciiCharset)charset).getBaseCharset();
        }
        return charset;
    }
}

