/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.javacvsImpl.ProjectContentInfoProvider;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ISendTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.LocalFileReader;

public class LocalFileReaderBasedOnVFS
implements ILocalFileReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.javacvsImpl.io.LocalFileReaderBasedOnVFS");
    private final ILocalFileReader myLocalFileReader;
    private final ProjectContentInfoProvider myProjectContentInfoProvider;

    public LocalFileReaderBasedOnVFS(ISendTextFilePreprocessor sendTextFilePreprocessor, ProjectContentInfoProvider projectContentInfoProvider) {
        this.myLocalFileReader = new LocalFileReader(sendTextFilePreprocessor);
        this.myProjectContentInfoProvider = projectContentInfoProvider;
    }

    public void transmitTextFile(FileObject fileObject, IConnectionStreams connectionStreams, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myLocalFileReader.transmitTextFile(fileObject, connectionStreams, cvsFileSystem);
    }

    public void transmitBinaryFile(FileObject fileObject, IConnectionStreams connectionStreams, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myLocalFileReader.transmitBinaryFile(fileObject, connectionStreams, cvsFileSystem);
    }

    public boolean exists(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) {
        return this.getVirtualFile(fileObject, cvsFileSystem) != null;
    }

    private VirtualFile getVirtualFile(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) {
        return CvsVfsUtil.findFileByIoFile(cvsFileSystem.getLocalFileSystem().getFile(fileObject));
    }

    public boolean isWritable(FileObject fileObject, ICvsFileSystem cvsFileSystem) {
        VirtualFile virtualFile = this.getVirtualFile((AbstractFileObject)fileObject, cvsFileSystem);
        if (virtualFile == null) {
            return false;
        }
        return CvsVfsUtil.isWritable(virtualFile);
    }

    public void listFilesAndDirectories(DirectoryObject directoryObject, Collection<String> fileNames, Collection<String> directoryNames, ICvsFileSystem cvsFileSystem) {
        VirtualFile virtualDirectory = this.getVirtualFile((AbstractFileObject)directoryObject, cvsFileSystem);
        if (virtualDirectory == null) {
            return;
        }
        VirtualFile[] children = CvsVfsUtil.getChildrenOf(virtualDirectory);
        if (children == null) {
            return;
        }
        for (VirtualFile fileOrDirectory : children) {
            if ("CVS".equals(fileOrDirectory.getName()) || !this.myProjectContentInfoProvider.fileIsUnderProject(fileOrDirectory)) continue;
            String name = fileOrDirectory.getName();
            if (fileOrDirectory.isDirectory()) {
                if (directoryNames == null) continue;
                directoryNames.add(name);
                continue;
            }
            if (fileNames == null) continue;
            LOG.assertTrue(name.length() > 0);
            fileNames.add(name);
        }
    }
}

