/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.history;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.LocalPathIndifferentLogOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui.TagsPanel;
import com.intellij.cvsSupport2.history.CvsFileRevision;
import com.intellij.cvsSupport2.history.CvsFileRevisionImpl;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TreeItem;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;

public class CvsHistoryProvider
implements VcsHistoryProvider {
    public static final ColumnInfo<VcsFileRevision, String> STATE = new ColumnInfo<VcsFileRevision, String>(CvsBundle.message((String)"file.history.state.column.name", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof CvsFileRevision)) {
                return "";
            }
            return ((CvsFileRevision)vcsFileRevision).getState();
        }

        public Comparator<VcsFileRevision> getComparator() {
            return new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision r1, VcsFileRevision r2) {
                    if (!(r1 instanceof CvsFileRevision)) {
                        return 1;
                    }
                    if (!(r2 instanceof CvsFileRevision)) {
                        return -1;
                    }
                    return ((CvsFileRevision)r1).getState().compareTo(((CvsFileRevision)r2).getState());
                }
            };
        }
    };
    private final ColumnInfo TAG = new TagOrBranchColumn(CvsBundle.message((String)"file.history.tag.column.name", (Object[])new Object[0])){

        @Override
        protected Collection<String> getValues(CvsFileRevision revision) {
            return revision.getTags();
        }
    };
    public final ColumnInfo BRANCHES = new TagOrBranchColumn(CvsBundle.message((String)"file.history.branches.column.name", (Object[])new Object[0])){

        @Override
        protected Collection<String> getValues(CvsFileRevision revision) {
            return revision.getBranches();
        }
    };
    private final Project myProject;

    public CvsHistoryProvider(Project project) {
        this.myProject = project;
    }

    public boolean isDateOmittable() {
        return false;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])new ColumnInfo[]{STATE, this.TAG, this.BRANCHES});
    }

    public String getHelpId() {
        return null;
    }

    @Nullable
    public VcsHistorySession createSessionFor(final FilePath filePath) {
        List<VcsFileRevision> fileRevisionList = this.createRevisions(filePath);
        if (fileRevisionList == null) {
            return null;
        }
        return new VcsAbstractHistorySession(fileRevisionList){

            @Nullable
            public VcsRevisionNumber calcCurrentRevisionNumber() {
                return CvsHistoryProvider.getCurrentRevision(filePath);
            }

            public synchronized boolean shouldBeRefreshed() {
                if (!CvsEntriesManager.getInstance().isActive()) {
                    return false;
                }
                return super.shouldBeRefreshed();
            }

            public boolean isContentAvailable(VcsFileRevision revision) {
                if (revision instanceof CvsFileRevision) {
                    CvsFileRevision cvsFileRevision = (CvsFileRevision)revision;
                    return !cvsFileRevision.getState().equals("dead");
                }
                return super.isContentAvailable(revision);
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return MyHistoryAsTreeProvider.getInstance();
            }
        };
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsHistorySession session = this.createSessionFor(path);
        partner.reportCreatedEmptySession((VcsAbstractHistorySession)session);
    }

    private static VcsRevisionNumber getCurrentRevision(FilePath filePath) {
        Entry entryFor = CvsEntriesManager.getInstance().getEntryFor(filePath.getVirtualFileParent(), filePath.getName());
        if (entryFor == null) {
            return new CvsRevisionNumber("0");
        }
        return new CvsRevisionNumber(entryFor.getRevision());
    }

    @Nullable
    public List<VcsFileRevision> createRevisions(final FilePath filePath) {
        final ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        VirtualFile root = CvsVfsUtil.refreshAndFindFileByIoFile(filePath.getIOFile().getParentFile());
        if (root == null) {
            return null;
        }
        final LocalPathIndifferentLogOperation logOperation = new LocalPathIndifferentLogOperation(filePath.getIOFile());
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"operation.name.load.file.content", (Object[])new Object[0]), logOperation), new CvsOperationExecutorCallback(){

            @Override
            public void executionFinished(boolean successfully) {
            }

            @Override
            public void executeInProgressAfterAction(ModalityContext modaityContext) {
            }

            @Override
            public void executionFinishedSuccessfully() {
                CvsConnectionSettings env = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(filePath.getVirtualFileParent());
                LogInformation firstLogInformation = logOperation.getFirstLogInformation();
                if (firstLogInformation != null) {
                    result.addAll(CvsHistoryProvider.createRevisionListOn(CvsUtil.getCvsLightweightFileForFile(filePath.getIOFile()), firstLogInformation, env, CvsHistoryProvider.this.myProject));
                }
            }
        });
        return result;
    }

    private static List<VcsFileRevision> createRevisionListOn(File file, @NotNull LogInformation logInformation, CvsEnvironment env, Project project) {
        if (logInformation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/cvsSupport2/history/CvsHistoryProvider.createRevisionListOn must not be null");
        }
        List revisionList = logInformation.getRevisionList();
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        for (Object aRevisionList : revisionList) {
            Revision revision = (Revision)aRevisionList;
            result.add(new CvsFileRevisionImpl(revision, file, logInformation, env, project));
        }
        return result;
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return AnAction.EMPTY_ARRAY;
    }

    public boolean supportsHistoryForDirectories() {
        return false;
    }

    private static class MyHistoryAsTreeProvider
    implements HistoryAsTreeProvider {
        private static MyHistoryAsTreeProvider ourInstance = new MyHistoryAsTreeProvider();

        private MyHistoryAsTreeProvider() {
        }

        public static MyHistoryAsTreeProvider getInstance() {
            return ourInstance;
        }

        public List<TreeItem<VcsFileRevision>> createTreeOn(List<VcsFileRevision> allRevisions) {
            List<VcsFileRevision> sortedRevisions = MyHistoryAsTreeProvider.sortRevisions(allRevisions);
            ArrayList<TreeItem<VcsFileRevision>> result = new ArrayList<TreeItem<VcsFileRevision>>();
            TreeItem prevRevision = null;
            for (VcsFileRevision sortedRevision : sortedRevisions) {
                CvsFileRevisionImpl cvsFileRevision = (CvsFileRevisionImpl)sortedRevision;
                TreeItem treeItem = new TreeItem((Object)cvsFileRevision);
                TreeItem<VcsFileRevision> commonParent = MyHistoryAsTreeProvider.getCommonParent(prevRevision, (TreeItem<VcsFileRevision>)treeItem);
                if (commonParent != null) {
                    commonParent.addChild(treeItem);
                } else {
                    result.add((TreeItem<VcsFileRevision>)treeItem);
                }
                prevRevision = treeItem;
            }
            return result;
        }

        @Nullable
        private static TreeItem<VcsFileRevision> getCommonParent(TreeItem<VcsFileRevision> prevRevision, TreeItem<VcsFileRevision> cvsFileRevision) {
            if (prevRevision == null) {
                return null;
            }
            while (!MyHistoryAsTreeProvider.isParent(prevRevision, cvsFileRevision)) {
                prevRevision = prevRevision.getParent();
            }
            return prevRevision;
        }

        private static boolean isParent(TreeItem<VcsFileRevision> prevRevision, TreeItem<VcsFileRevision> cvsFileRevision) {
            if (prevRevision == null) {
                return true;
            }
            CvsFileRevisionImpl prevData = (CvsFileRevisionImpl)prevRevision.getData();
            CvsFileRevisionImpl data = (CvsFileRevisionImpl)cvsFileRevision.getData();
            return data.getRevisionNumber().asString().startsWith(prevData.getRevisionNumber().asString());
        }

        private static List<VcsFileRevision> sortRevisions(List<VcsFileRevision> revisionsList) {
            Collections.sort(revisionsList, new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision rev1, VcsFileRevision rev2) {
                    return VcsHistoryUtil.compare((VcsFileRevision)rev1, (VcsFileRevision)rev2);
                }
            });
            return revisionsList;
        }
    }

    abstract class TagOrBranchColumn
    extends ColumnInfo {
        public TagOrBranchColumn(String name) {
            super(name);
        }

        public TableCellRenderer getRenderer(Object object) {
            TableCellRenderer rendererFromSuper = super.getRenderer(object);
            if (!(object instanceof CvsFileRevision)) {
                return rendererFromSuper;
            }
            Collection<String> tags = this.getValues((CvsFileRevision)object);
            if (tags.size() < 2) {
                return rendererFromSuper;
            }
            return new TagsPanel(this.getName());
        }

        public boolean isCellEditable(Object object) {
            if (!(object instanceof CvsFileRevision)) {
                return false;
            }
            return this.getValues((CvsFileRevision)object).size() > 1;
        }

        public TableCellEditor getEditor(final Object object) {
            if (!(object instanceof CvsFileRevision)) {
                return null;
            }
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    return "";
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    TagsPanel result = new TagsPanel(TagOrBranchColumn.this.getName());
                    result.setTags(TagOrBranchColumn.this.getValues((CvsFileRevision)object));
                    result.setSelected(true, table);
                    return result;
                }
            };
        }

        protected abstract Collection<String> getValues(CvsFileRevision var1);

        public Object valueOf(Object object) {
            if (!(object instanceof CvsFileRevision)) {
                return "";
            }
            Collection<String> values = this.getValues((CvsFileRevision)object);
            if (values.isEmpty()) {
                return "";
            }
            if (values.size() == 1) {
                return values.iterator().next().toString();
            }
            return values;
        }
    }
}

