/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class FindAllRoots {
    private final CvsEntriesManager myManager = CvsEntriesManager.getInstance();
    private int myProcessedFiles;
    private int mySuitableFiles;
    private final Collection<File> myRepositories = new HashSet<File>();
    private final Collection<VirtualFile> myResult = new ArrayList<VirtualFile>();
    private final ProgressIndicator myProgress = ProgressManager.getInstance().getProgressIndicator();
    private final ProjectRootManager myProjectRootManager;

    public FindAllRoots(Project project) {
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> executeOn(FilePath[] roots) {
        final Collection<FilePath> rootsWithoutIntersections = FindAllRoots.getRootsWithoutIntersections(roots);
        this.setText(CvsBundle.message((String)"progress.text.searching.for.cvs.root", (Object[])new Object[0]));
        this.myManager.lockSynchronizationActions();
        this.mySuitableFiles = this.calcVirtualFilesUnderCvsIn(rootsWithoutIntersections) * 2;
        this.myProcessedFiles = 0;
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (FilePath file : rootsWithoutIntersections) {
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null) {
                            FindAllRoots.this.myResult.add(virtualFile);
                            FindAllRoots.this.process(virtualFile);
                            continue;
                        }
                        VirtualFile virtualFileParent = file.getVirtualFileParent();
                        if (virtualFileParent == null) continue;
                        FindAllRoots.this.myResult.add(virtualFileParent);
                    }
                }
            });
        }
        finally {
            this.myManager.unlockSynchronizationActions();
        }
        return this.myResult;
    }

    private int calcVirtualFilesUnderCvsIn(Collection<FilePath> rootsWithoutIntersections) {
        int result = 0;
        for (FilePath cvsFileWrapper : rootsWithoutIntersections) {
            if (!cvsFileWrapper.isDirectory()) {
                ++result;
                continue;
            }
            result += this.calcVirtualFilesUnderCvsIn(cvsFileWrapper.getVirtualFile());
        }
        return result;
    }

    private int calcVirtualFilesUnderCvsIn(VirtualFile file) {
        if (file == null || !file.isDirectory()) {
            return 0;
        }
        if (!this.myProjectRootManager.getFileIndex().isInContent(file)) {
            return 0;
        }
        int result = 0;
        if (file.findChild("CVS") == null) {
            return result;
        }
        ++result;
        VirtualFile[] children = file.getChildren();
        if (children == null) {
            return result;
        }
        for (VirtualFile child : children) {
            if (child.getName() == "CVS") continue;
            result += this.calcVirtualFilesUnderCvsIn(child);
        }
        return result;
    }

    private static Collection<FilePath> getRootsWithoutIntersections(FilePath[] roots) {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        List<FilePath> list = Arrays.asList(roots);
        Collections.sort(list, new Comparator<FilePath>(){

            @Override
            public int compare(FilePath file, FilePath file1) {
                return file.getPath().compareTo(file1.getPath());
            }
        });
        FilePath[] sortedRoots = list.toArray(new FilePath[list.size()]);
        for (int i = 0; i < sortedRoots.length; ++i) {
            FilePath prevRoot;
            FilePath root = sortedRoots[i];
            if (i == 0) {
                result.add(root);
                continue;
            }
            FilePath filePath = prevRoot = result.isEmpty() ? null : result.get(result.size() - 1);
            if (prevRoot != null && VfsUtil.isAncestor((File)prevRoot.getIOFile(), (File)root.getIOFile(), (boolean)false)) continue;
            result.add(root);
        }
        return result;
    }

    private void setText(String text) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.setText(text);
        ProgressManager.checkCanceled();
    }

    private void setText2(String text) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.setText2(text);
        ProgressManager.checkCanceled();
    }

    private void process(VirtualFile root) {
        if (!this.myProjectRootManager.getFileIndex().isInContent(root)) {
            return;
        }
        this.setText2(CvsVfsUtil.getPresentablePathFor(root));
        ++this.myProcessedFiles;
        this.setFraction();
        VirtualFile[] children = root.getChildren();
        if (children == null) {
            return;
        }
        CvsConnectionSettings parentEnv = this.myManager.getCvsConnectionSettingsFor(root);
        if (!parentEnv.isValid()) {
            return;
        }
        this.myManager.cacheCvsAdminInfoIn(root);
        this.myRepositories.add(CvsVfsUtil.getFileFor(root));
        for (VirtualFile child : children) {
            CvsConnectionSettings childEnv;
            if (!child.isDirectory() || !this.myProjectRootManager.getFileIndex().isInContent(child) || (childEnv = this.myManager.getCvsConnectionSettingsFor(child)) == null || !childEnv.isValid()) continue;
            if (!((Object)((Object)childEnv)).equals((Object)parentEnv)) {
                this.myResult.add(child);
            }
            this.process(child);
        }
    }

    private void setFraction() {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.setFraction((double)this.myProcessedFiles / (double)this.mySuitableFiles);
        ProgressManager.checkCanceled();
    }

    public Collection<File> getDirectoriesToBeUpdated() {
        return this.myRepositories;
    }
}

