/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CvsMessagesConsole;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorMessagesProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public abstract class CvsHandler
extends CvsMessagesAdapter {
    @NonNls
    private static final String NULL_HANDLER_NAME = "Null";
    public static CvsHandler NULL = new CvsHandler("Null", FileSetToBeUpdated.EMPTY){

        @Override
        protected void addCvsListener(CvsMessagesListener listener) {
        }

        @Override
        protected void removeCvsListener(CvsMessagesListener listener) {
        }

        @Override
        protected int getFilesToProcessCount() {
            return 0;
        }

        @Override
        public boolean isCanceled() {
            return true;
        }

        @Override
        public boolean login(ModalityContext executor) throws Exception {
            return false;
        }
    };
    public static final int UNKNOWN_COUNT = -1;
    protected final List<VcsException> myErrors = new ArrayList<VcsException>();
    protected ErrorMessagesProcessor myErrorMessageProcessor = new ErrorMessagesProcessor(this.myErrors);
    private int myFilesToProcess = -1;
    private int myProcessedFiles = 0;
    private final CvsMessagesConsole myMessagesConsole;
    private final String myTitle;
    protected CvsListenerWithProgress myProgressListener;
    private final FileSetToBeUpdated myFiles;

    public CvsHandler(String title, FileSetToBeUpdated files) {
        this.myTitle = title;
        this.myMessagesConsole = new CvsMessagesConsole();
        this.myFiles = files;
    }

    public void internalRun(ModalityContext executor, boolean runInReadAction) {
    }

    protected abstract void addCvsListener(CvsMessagesListener var1);

    protected abstract void removeCvsListener(CvsMessagesListener var1);

    public String getTitle() {
        return this.myTitle;
    }

    public List<VcsException> getErrors() {
        return this.myErrorMessageProcessor.getErrors();
    }

    public List<VcsException> getErrorsExceptAborted() {
        ArrayList<VcsException> result = new ArrayList<VcsException>();
        for (VcsException ex : this.myErrorMessageProcessor.getErrors()) {
            if (ex.getCause() instanceof CommandAbortedException) continue;
            result.add(ex);
        }
        return result;
    }

    public List<VcsException> getWarnings() {
        return this.myErrorMessageProcessor.getWarnings();
    }

    @Override
    public void addFileMessage(String message, ICvsFileSystem cvsFileSystem) {
        this.setText2(message);
        this.incProgress();
    }

    @Override
    public void addMessage(String message) {
        this.setText2(message);
    }

    private void setText2(String message) {
        if (this.getProgress() != null) {
            this.getProgress().setText2(message);
        }
    }

    protected void incProgress() {
        if (this.getProgress() == null) {
            return;
        }
        ++this.myProcessedFiles;
        if (this.myFilesToProcess == -1) {
            this.myFilesToProcess = this.getFilesToProcessCount();
        }
        if (this.myFilesToProcess != -1) {
            this.getProgress().setFraction((double)this.myProcessedFiles / (double)this.myFilesToProcess);
        }
    }

    protected abstract int getFilesToProcessCount();

    public void connectToOutputView(Editor editor, Project project) {
        this.myMessagesConsole.connectToOutputView(editor, project);
    }

    protected boolean runInReadThread() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ModalityContext executor) {
        this.initializeListeners();
        try {
            this.internalRun(executor, this.runInReadThread());
        }
        finally {
            this.deinitializeListeners();
        }
        if (this.isCanceled()) {
            throw new ProcessCanceledException();
        }
        ProgressIndicator progress = this.getProgress();
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    private void deinitializeListeners() {
        this.removeCvsListener(this.getProgressListener());
        this.removeCvsListener(this.myMessagesConsole);
        this.removeCvsListener(this);
        this.removeCvsListener(this.myErrorMessageProcessor);
    }

    protected CvsListenerWithProgress getProgressListener() {
        if (this.myProgressListener == null) {
            this.myProgressListener = CvsListenerWithProgress.createOnProgress();
        }
        return this.myProgressListener;
    }

    private void initializeListeners() {
        this.addCvsListener(this.getProgressListener());
        this.addCvsListener(this.myMessagesConsole);
        this.addCvsListener(this);
        this.addCvsListener(this.myErrorMessageProcessor);
    }

    protected ProgressIndicator getProgress() {
        return this.getProgressListener().getProgressIndicator();
    }

    public void runComplitingActivities() {
    }

    public void beforeLogin() {
    }

    public abstract boolean login(ModalityContext var1) throws Exception;

    public FileSetToBeUpdated getFiles() {
        return this.myFiles;
    }

    public boolean canBeCanceled() {
        return true;
    }

    public abstract boolean isCanceled();

    public String getCancelButtonText() {
        return null;
    }

    public PerformInBackgroundOption getBackgroundOption(Project project) {
        return null;
    }
}

