/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsExecution;

import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;

public class ModalityContextImpl
implements ModalityContext {
    private final ModalityState myDefaultModalityState;
    public static final ModalityContext NON_MODAL = new ModalityContextImpl(ModalityState.NON_MODAL, false);
    private final boolean myIsForTemporaryConfiguration;

    public ModalityContextImpl(boolean forTemp) {
        this(ModalityState.current(), forTemp);
    }

    public ModalityContextImpl(ModalityState defaultModalityState, boolean forTemp) {
        this.myDefaultModalityState = defaultModalityState;
        this.myIsForTemporaryConfiguration = forTemp;
    }

    public void runInDispatchThread(Runnable action, Project project) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isDispatchThread()) {
            action.run();
        } else {
            ModalityState modalityState = this.getCurrentModalityState();
            PeriodicalTasksCloser.invokeAndWaitInterruptedWhenClosing((Project)project, (Runnable)action, (ModalityState)modalityState);
        }
    }

    private ModalityState getCurrentModalityState() {
        ModalityState modalityState;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ModalityState modalityState2 = modalityState = progressIndicator == null ? this.myDefaultModalityState : progressIndicator.getModalityState();
        if (modalityState == null) {
            modalityState = ModalityState.defaultModalityState();
        }
        return modalityState;
    }

    public boolean isForTemporaryConfiguration() {
        return this.myIsForTemporaryConfiguration;
    }
}

