/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.PServerPasswordScrambler;

public class SSHPasswordProviderImpl
implements ApplicationComponent,
JDOMExternalizable,
SSHPasswordProvider {
    private final Map<String, String> myCvsRootToPasswordMap = new HashMap();
    private final Map<String, String> myCvsRootToStoringPasswordMap = new HashMap();
    private final Map<String, String> myCvsRootToPPKPasswordMap = new HashMap();
    private final Map<String, String> myCvsRootToStoringPPKPasswordMap = new HashMap();
    private final Object myLock = new Object();
    @NonNls
    private static final String PASSWORDS = "passwords";
    @NonNls
    private static final String PASSWORD = "password";
    @NonNls
    private static final String PPKPASSWORDS = "ppkpasswords";
    @NonNls
    private static final String CVSROOT_ATTR = "CVSROOT";
    @NonNls
    private static final String PASSWORD_ATTR = "PASSWORD";

    public static SSHPasswordProviderImpl getInstance() {
        return (SSHPasswordProviderImpl)ServiceManager.getService(SSHPasswordProviderImpl.class);
    }

    @NotNull
    public String getComponentName() {
        if ("SSHPasswordProvider" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/connections/ssh/SSHPasswordProviderImpl.getComponentName must not return null");
        }
        return "SSHPasswordProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPasswordForCvsRoot(String cvsRoot) {
        Object object = this.myLock;
        synchronized (object) {
            String password = this.myCvsRootToStoringPasswordMap.get(cvsRoot);
            if (password != null) {
                return password;
            }
            return this.myCvsRootToPasswordMap.get(cvsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePasswordForCvsRoot(String cvsRoot, String password, boolean storeInWorkspace) {
        Object object = this.myLock;
        synchronized (object) {
            if (storeInWorkspace) {
                this.myCvsRootToStoringPasswordMap.put(cvsRoot, password);
            } else {
                this.myCvsRootToPasswordMap.put(cvsRoot, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPPKPasswordForCvsRoot(String cvsRoot) {
        Object object = this.myLock;
        synchronized (object) {
            String password = this.myCvsRootToStoringPPKPasswordMap.get(cvsRoot);
            if (password != null) {
                return password;
            }
            return this.myCvsRootToPPKPasswordMap.get(cvsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePPKPasswordForCvsRoot(String cvsRoot, String password, boolean storeInWorkspace) {
        Object object = this.myLock;
        synchronized (object) {
            if (storeInWorkspace) {
                this.myCvsRootToStoringPPKPasswordMap.put(cvsRoot, password);
            } else {
                this.myCvsRootToPPKPasswordMap.put(cvsRoot, password);
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element password;
        Element passwords = new Element(PASSWORDS);
        for (String cvsRoot : this.myCvsRootToStoringPasswordMap.keySet()) {
            password = new Element(PASSWORD);
            password.setAttribute(CVSROOT_ATTR, cvsRoot);
            password.setAttribute(PASSWORD_ATTR, PServerPasswordScrambler.getInstance().scramble(this.myCvsRootToStoringPasswordMap.get(cvsRoot)));
            passwords.addContent(password);
        }
        element.addContent(passwords);
        passwords = new Element(PPKPASSWORDS);
        for (String cvsRoot : this.myCvsRootToStoringPPKPasswordMap.keySet()) {
            password = new Element(PASSWORD);
            password.setAttribute(CVSROOT_ATTR, cvsRoot);
            password.setAttribute(PASSWORD_ATTR, PServerPasswordScrambler.getInstance().scramble(this.myCvsRootToStoringPPKPasswordMap.get(cvsRoot)));
            passwords.addContent(password);
        }
        element.addContent(passwords);
    }

    public void readExternal(Element element) throws InvalidDataException {
        String password;
        String cvsRoot;
        Element passwords = element.getChild(PASSWORDS);
        if (passwords != null) {
            for (Element passElement : passwords.getChildren(PASSWORD)) {
                cvsRoot = passElement.getAttributeValue(CVSROOT_ATTR);
                password = passElement.getAttributeValue(PASSWORD_ATTR);
                if (cvsRoot == null || password == null) continue;
                this.myCvsRootToStoringPasswordMap.put(cvsRoot, PServerPasswordScrambler.getInstance().unscramble(password));
            }
        }
        if ((passwords = element.getChild(PPKPASSWORDS)) != null) {
            for (Element passElement : passwords.getChildren(PASSWORD)) {
                cvsRoot = passElement.getAttributeValue(CVSROOT_ATTR);
                password = passElement.getAttributeValue(PASSWORD_ATTR);
                if (cvsRoot == null || password == null) continue;
                this.myCvsRootToStoringPPKPasswordMap.put(cvsRoot, PServerPasswordScrambler.getInstance().unscramble(password));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePasswordFor(String stringRepsentation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCvsRootToPasswordMap.remove(stringRepsentation);
            this.myCvsRootToStoringPasswordMap.remove(stringRepsentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePPKPasswordFor(String stringRepsentation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCvsRootToPPKPasswordMap.remove(stringRepsentation);
            this.myCvsRootToStoringPPKPasswordMap.remove(stringRepsentation);
        }
    }
}

