/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsConflictsParser;
import com.intellij.cvsSupport2.actions.merge.MergeDataProvider;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CvsMergeProvider
implements MergeProvider {
    @NotNull
    public MergeData loadRevisions(VirtualFile file) throws VcsException {
        MergeData mergeData = CvsMergeProvider.parseConflictsInFile(file).createData();
        if (mergeData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/actions/merge/CvsMergeProvider.loadRevisions must not return null");
        }
        return mergeData;
    }

    public void conflictResolvedForFile(VirtualFile file) {
        CvsUtil.resolveConflict(file);
    }

    public boolean isBinary(VirtualFile file) {
        return false;
    }

    @NotNull
    private static MergeDataProvider parseConflictsInFile(final VirtualFile file) {
        MergeDataProvider mergeDataProvider = new MergeDataProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            @NotNull
            public MergeData createData() throws VcsException {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(CvsVfsUtil.getFileFor(file)));
                CvsConflictsParser parser = CvsConflictsParser.createOn(input);
                MergeData mergeData = new MergeData();
                mergeData.ORIGINAL = parser.getCenterVersion().getBytes();
                mergeData.CURRENT = parser.getLeftVersion().getBytes();
                mergeData.LAST = parser.getRightVersion().getBytes();
                MergeData mergeData2 = mergeData;
                input.close();
                MergeData mergeData3 = mergeData2;
                if (mergeData3 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/actions/merge/CvsMergeProvider$1.createData must not return null");
                }
                return mergeData3;
                {
                    catch (Throwable throwable) {
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new VcsException((Throwable)e);
                        }
                    }
                }
            }
        };
        if (mergeDataProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/actions/merge/CvsMergeProvider.parseConflictsInFile must not return null");
        }
        return mergeDataProvider;
    }
}

