/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ui.Refreshable;
import java.awt.event.InputEvent;
import javax.swing.Icon;

public abstract class AbstractAction
extends AnAction {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.actions.AbstractAction");
    private final boolean myStartLvcsAction;
    private boolean myAutoSave = true;
    private LocalHistoryAction myLocalHistoryAction = LocalHistoryAction.NULL;

    public AbstractAction(boolean startLvcsAction) {
        this.myStartLvcsAction = startLvcsAction;
    }

    public AbstractAction(boolean startLvcsAction, String name, Icon icon) {
        super(name, null, icon);
        this.myStartLvcsAction = startLvcsAction;
    }

    public AbstractAction setAutoSave(boolean autoSave) {
        this.myAutoSave = autoSave;
        return this;
    }

    protected void beforeActionPerformed(VcsContext context) {
    }

    public void actionPerformed(AnActionEvent e) {
        this.actionPerformed(CvsContextWrapper.createCachedInstance(e));
    }

    protected abstract String getTitle(VcsContext var1);

    protected abstract CvsHandler getCvsHandler(CvsContext var1);

    public void actionPerformed(final CvsContext context) {
        Runnable beforeAction = new Runnable(){

            @Override
            public void run() {
                AbstractAction.this.beforeActionPerformed(context);
            }
        };
        Runnable afterAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<AbstractAction> clazz = AbstractAction.class;
                synchronized (AbstractAction.class) {
                    CvsHandler handler;
                    try {
                        handler = AbstractAction.this.getCvsHandler(context);
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                        handler = CvsHandler.NULL;
                    }
                    LOG.assertTrue(handler != null);
                    AbstractAction.this.actionPerformed(context, handler);
                    return;
                }
            }
        };
        if (ProgressManager.getInstance().getProgressIndicator() != null) {
            beforeAction.run();
            afterAction.run();
        } else if (ProgressManager.getInstance().runProcessWithProgressSynchronously(beforeAction, this.getTitle(context), true, context.getProject())) {
            afterAction.run();
        }
    }

    public void actionPerformed(CvsContext context, CvsHandler handler) {
        this.start(context);
        Project project = context.getProject();
        try {
            this.performAction(project, handler, context);
        }
        catch (Exception e1) {
            LOG.error((Throwable)e1);
        }
    }

    private void startAction(VcsContext context) {
        if (!this.myStartLvcsAction) {
            return;
        }
        Project project = context.getProject();
        if (project == null || this.getTitle(context) == null) {
            return;
        }
        String name = CvsBundle.getCvsDisplayName() + ": " + this.getTitle(context);
        this.myLocalHistoryAction = LocalHistory.startAction((Project)project, (String)name);
    }

    protected void endAction() {
        this.myLocalHistoryAction.finish();
        this.myLocalHistoryAction = LocalHistoryAction.NULL;
    }

    protected void start(VcsContext context) {
        Project project = context.getProject();
        if (project != null && ApplicationManager.getApplication().isDispatchThread() && this.myAutoSave) {
            ApplicationManager.getApplication().saveAll();
        }
    }

    protected void performAction(Project project, CvsHandler handler, CvsContext context) {
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(handler, new MyCvsOperationExecutorCallback(context, handler, executor));
    }

    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        if (handler == CvsHandler.NULL) {
            return;
        }
        Refreshable refreshablePanel = context.getRefreshableDialog();
        if (refreshablePanel != null) {
            refreshablePanel.refresh();
        }
    }

    protected static void adjustName(boolean showDialogOptions, AnActionEvent e) {
        boolean actualShow = showDialogOptions || AbstractAction.shiftPressed(e);
        Presentation presentation = e.getPresentation();
        String itemText = e.getPresentation().getTextWithMnemonic();
        if (itemText == null) {
            return;
        }
        if (itemText.endsWith("...")) {
            if (actualShow) {
                return;
            }
            presentation.setText(itemText.substring(0, itemText.length() - 3));
        } else {
            if (!actualShow) {
                return;
            }
            presentation.setText(itemText + "...");
        }
    }

    private static boolean shiftPressed(AnActionEvent e) {
        InputEvent inputEvent = e.getInputEvent();
        return inputEvent != null && (inputEvent.getModifiers() & 1) != 0;
    }

    private class MyCvsOperationExecutorCallback
    implements CvsOperationExecutorCallback {
        private final CvsContext myContext;
        private final CvsHandler myHandler;
        private final CvsOperationExecutor myExecutor;

        public MyCvsOperationExecutorCallback(CvsContext context, CvsHandler handler, CvsOperationExecutor executor) {
            this.myContext = context;
            this.myHandler = handler;
            this.myExecutor = executor;
        }

        @Override
        public void executeInProgressAfterAction(ModalityContext modalityContext) {
            AbstractAction.this.startAction(this.myContext);
            FileSetToBeUpdated files = this.myHandler.getFiles();
            files.refreshFilesAsync(new Runnable(){

                @Override
                public void run() {
                    AbstractAction.this.endAction();
                }
            });
        }

        @Override
        public void executionFinished(boolean successfully) {
            CvsTabbedWindow tabbedWindow = this.myExecutor.openTabbedWindow(this.myHandler);
            AbstractAction.this.onActionPerformed(this.myContext, tabbedWindow, successfully, this.myHandler);
        }

        @Override
        public void executionFinishedSuccessfully() {
        }
    }
}

