/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.external;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import org.gradle.BootstrapLoader;

public class ExternalUtility {
    public static ClassLoader getGradleClassloader(ClassLoader parentClassLoader, File gradleHomeDirectory, boolean showDebugInfo) throws Exception {
        File gradleJarFile = ExternalUtility.getGradleJar(gradleHomeDirectory);
        if (gradleJarFile == null) {
            throw new RuntimeException("Not a valid gradle home directory '" + gradleHomeDirectory.getAbsolutePath() + "'");
        }
        System.setProperty("gradle.home", gradleHomeDirectory.getAbsolutePath());
        BootstrapLoader bootstrapLoader = new BootstrapLoader();
        bootstrapLoader.initialize(parentClassLoader, gradleHomeDirectory, true, false, showDebugInfo);
        return bootstrapLoader.getClassLoader();
    }

    public static File getGradleJar(File gradleHomeDirectory) {
        File libDirectory = new File(gradleHomeDirectory, "lib");
        if (!libDirectory.exists()) {
            return null;
        }
        File[] files = libDirectory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith("gradle-core-") && name.endsWith(".jar");
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length > 1) {
            throw new RuntimeException("Installation has multiple gradle jars. Cannot determine which one to use. Found files: " + files);
        }
        return files[0];
    }

    public static String dumpConstructors(Class classInQuestion) {
        StringBuilder builder = new StringBuilder();
        Constructor<?>[] constructors = classInQuestion.getConstructors();
        for (int index = 0; index < constructors.length; ++index) {
            Constructor<?> constructor = constructors[index];
            builder.append(constructor).append('\n');
        }
        return builder.toString();
    }
}

