/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class TypeNameManager {
    public static final Map<Class, String> ourTypeNames = new HashMap<Class, String>();
    public static final List<Function<Class, String>> ourTypeProviders = new ArrayList<Function<Class, String>>();

    private TypeNameManager() {
    }

    public static void registerTypeProvider(Function<Class, String> function) {
        ourTypeProviders.add(function);
    }

    public static void unregisterTypeProvider(Function<Class, String> function) {
        ourTypeProviders.remove(function);
    }

    public static String getTypeName(Class aClass) {
        String s = TypeNameManager._getTypeName(aClass);
        if (s != null) {
            return s;
        }
        return TypeNameManager.getDefaultTypeName(aClass);
    }

    public static String getDefaultTypeName(Class aClass) {
        String simpleName = aClass.getSimpleName();
        int i = simpleName.indexOf(36);
        if (i >= 0) {
            simpleName = simpleName.substring(i + 1);
        }
        return StringUtil.capitalizeWords((String)StringUtil.join((String[])NameUtil.nameToWords((String)simpleName), (String)" "), (boolean)true);
    }

    @Nullable
    public static <T> T getFromClassMap(Map<Class, T> map, Class value) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(value)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static String _getTypeName(Class aClass) {
        for (Function<Class, String> function : ourTypeProviders) {
            String s = (String)function.fun((Object)aClass);
            if (s == null) continue;
            return s;
        }
        return TypeNameManager.getFromClassMap(ourTypeNames, aClass);
    }

    public static void registerTypeName(Class aClass, @NonNls String typeName) {
        ourTypeNames.put(aClass, typeName);
    }
}

