/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Scope;
import com.intellij.util.xml.ScopeProvider;
import com.intellij.util.xml.TypeChooser;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileDescription<T> {
    public static final ExtensionPointName<DomFileDescription> EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileDescription");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.DomFileDescription");
    private final ConcurrentInstanceMap<ScopeProvider> myScopeProviders = new ConcurrentInstanceMap();
    protected final Class<T> myRootElementClass;
    protected final String myRootTagName;
    private final String[] myAllPossibleRootTagNamespaces;
    private volatile boolean myInitialized;
    private final Map<Class<? extends DomElement>, Class<? extends DomElement>> myImplementations = new HashMap<Class<? extends DomElement>, Class<? extends DomElement>>();
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    private final List<DomReferenceInjector> myInjectors = new ArrayList<DomReferenceInjector>();
    private final Map<String, NotNullFunction<XmlTag, List<String>>> myNamespacePolicies = new ConcurrentHashMap();

    public DomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, String ... allPossibleRootTagNamespaces) {
        this.myRootElementClass = rootElementClass;
        this.myRootTagName = rootTagName;
        this.myAllPossibleRootTagNamespaces = allPossibleRootTagNamespaces;
    }

    public String[] getAllPossibleRootTagNamespaces() {
        return this.myAllPossibleRootTagNamespaces;
    }

    public final <T extends DomElement> void registerImplementation(Class<T> domElementClass, Class<? extends T> implementationClass) {
        this.myImplementations.put(domElementClass, implementationClass);
    }

    protected final void registerNamespacePolicy(String namespaceKey, NotNullFunction<XmlTag, List<String>> policy) {
        this.myNamespacePolicies.put(namespaceKey, policy);
    }

    public final void registerNamespacePolicy(String namespaceKey, final String ... namespaces) {
        this.registerNamespacePolicy(namespaceKey, new NotNullFunction<XmlTag, List<String>>(){

            @NotNull
            public List<String> fun(XmlTag tag) {
                List<String> list = Arrays.asList(namespaces);
                if (list == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription$1.fun must not return null");
                }
                return list;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<String> getAllowedNamespaces(@NotNull String namespaceKey, @NotNull XmlFile file) {
        List list;
        if (namespaceKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomFileDescription.getAllowedNamespaces must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomFileDescription.getAllowedNamespaces must not be null");
        }
        NotNullFunction<XmlTag, List<String>> function = this.myNamespacePolicies.get(namespaceKey);
        if (function != null) {
            XmlTag tag;
            XmlDocument document = file.getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                list = (List)function.fun((Object)tag);
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getAllowedNamespaces must not return null");
                return list;
            }
        } else {
            list = Collections.singletonList(namespaceKey);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getAllowedNamespaces must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getAllowedNamespaces must not return null");
    }

    @Deprecated
    protected final void registerClassChooser(Type aClass, TypeChooser typeChooser, Disposable parentDisposable) {
        this.registerTypeChooser(aClass, typeChooser);
    }

    protected final void registerTypeChooser(Type aClass, TypeChooser typeChooser) {
        this.myTypeChooserManager.registerTypeChooser(aClass, typeChooser);
    }

    public final TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    protected final void registerReferenceInjector(DomReferenceInjector injector) {
        this.myInjectors.add(injector);
    }

    public List<DomReferenceInjector> getReferenceInjectors() {
        return this.myInjectors;
    }

    public boolean isAutomaticHighlightingEnabled() {
        return true;
    }

    protected void initializeFileDescription() {
    }

    @Nullable
    public DomElementsAnnotator createAnnotator() {
        return null;
    }

    public final Map<Class<? extends DomElement>, Class<? extends DomElement>> getImplementations() {
        if (!this.myInitialized) {
            this.initializeFileDescription();
            this.myInitialized = true;
        }
        return this.myImplementations;
    }

    @NotNull
    public final Class<T> getRootElementClass() {
        Class<T> clazz = this.myRootElementClass;
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getRootElementClass must not return null");
        }
        return clazz;
    }

    public final String getRootTagName() {
        return this.myRootTagName;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomFileDescription.isMyFile must not be null");
        }
        Namespace namespace = DomReflectionUtil.findAnnotationDFS(this.myRootElementClass, Namespace.class);
        if (namespace != null) {
            XmlTag tag;
            String key = namespace.value();
            NotNullFunction<XmlTag, List<String>> function = this.myNamespacePolicies.get(key);
            LOG.assertTrue(function != null, (Object)("No namespace policy for namespace " + key + " in " + this));
            XmlDocument document = file.getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                String publicId;
                XmlDoctype doctype;
                List list = (List)function.fun((Object)tag);
                if (list.contains(tag.getNamespace())) {
                    return true;
                }
                XmlProlog prolog = document.getProlog();
                if (prolog != null && (doctype = prolog.getDoctype()) != null && (publicId = doctype.getPublicId()) != null && list.contains(publicId)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean acceptsOtherRootTagNames() {
        return false;
    }

    @NotNull
    public Set<? extends Object> getDependencyItems(XmlFile file) {
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getDependencyItems must not return null");
        }
        return set;
    }

    @NotNull
    public Set<Class<? extends DomElement>> getDomModelDependencyItems() {
        Set<Class<? extends DomElement>> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getDomModelDependencyItems must not return null");
        }
        return set;
    }

    @NotNull
    public Set<XmlFile> getDomModelDependentFiles(@NotNull DomFileElement changedRoot) {
        if (changedRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomFileDescription.getDomModelDependentFiles must not be null");
        }
        Set<XmlFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getDomModelDependentFiles must not return null");
        }
        return set;
    }

    protected static Set<Class<? extends DomElement>> convertToSet(Class<? extends DomElement> classes) {
        return new THashSet(Arrays.asList(classes));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DomElement getResolveScope(GenericDomValue<?> reference) {
        DomElement domElement;
        DomElement annotation = this.getScopeFromAnnotation(reference);
        if (annotation != null) {
            domElement = annotation;
            if (domElement == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getResolveScope must not return null");
            return domElement;
        }
        domElement = DomUtil.getRoot(reference);
        if (domElement != null) return domElement;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getResolveScope must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        DomElement domElement;
        DomElement annotation = this.getScopeFromAnnotation(element);
        if (annotation != null) {
            domElement = annotation;
            if (domElement == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getIdentityScope must not return null");
            return domElement;
        }
        domElement = element.getParent();
        if (domElement != null) return domElement;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileDescription.getIdentityScope must not return null");
    }

    @Nullable
    protected final DomElement getScopeFromAnnotation(DomElement element) {
        Scope scope = element.getAnnotation(Scope.class);
        if (scope != null) {
            return ((ScopeProvider)this.myScopeProviders.get(scope.value())).getScope(element);
        }
        return null;
    }
}

