/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;

public abstract class Timer
implements Disposable,
Runnable {
    private final int mySpan;
    private volatile boolean myRunning;
    private volatile boolean myDisposed;
    private volatile boolean myRestartRequest;
    private final String myName;
    private volatile boolean myTakeInitialDelay = true;
    private volatile boolean myInitiallySlept = false;
    private ThreadRunner myRunner;
    private Exception myInterruptedException;
    private final Object LOCK = new Object();

    public Timer(String name, int span) {
        this.myName = name;
        this.mySpan = span;
    }

    public void setTakeInitialDelay(boolean take) {
        this.myTakeInitialDelay = take;
    }

    public final int getSpan() {
        return this.mySpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myRunning = true;
            if (this.myRunner != null) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            this.myRunner = app != null ? new AppPool() : new PlainThread();
            this.myRunner.run(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (true) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.myRunning || this.myDisposed) {
                        this.myRunner = null;
                        this.resetToStart();
                        break;
                    }
                }
                if (this.myTakeInitialDelay || this.myInitiallySlept) {
                    Thread.currentThread();
                    Thread.sleep(this.mySpan);
                }
                this.myInitiallySlept = true;
                if (this.myRestartRequest) {
                    this.myRestartRequest = false;
                    continue;
                }
                this.onTimer();
            }
        }
        catch (InterruptedException e) {
            this.myInterruptedException = e;
            this.resetToStart();
        }
    }

    private void resetToStart() {
        this.myRestartRequest = false;
        this.myInitiallySlept = false;
    }

    protected abstract void onTimer() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            if (this.myRunning) {
                this.myRunning = false;
            } else {
                this.resetToStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDisposed = true;
            this.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this.LOCK;
        synchronized (object) {
            this.start();
            this.myRestartRequest = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDisposed;
        }
    }

    public String toString() {
        return "Timer=" + this.myName;
    }

    static class PlainThread
    implements ThreadRunner {
        private Thread myThread;

        PlainThread() {
        }

        @Override
        public void run(Runnable runnable) {
            this.myThread = new Thread(runnable, "timer thread");
            this.myThread.start();
        }
    }

    static class AppPool
    implements ThreadRunner {
        AppPool() {
        }

        @Override
        public void run(Runnable runnable) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    static interface ThreadRunner {
        public void run(Runnable var1);
    }
}

