/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.GuiUtils;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.HTTPProxySettingsPanel;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;

public class HttpConfigurable
implements JDOMExternalizable,
ApplicationComponent,
SearchableConfigurable {
    public boolean USE_HTTP_PROXY = false;
    public String PROXY_HOST = "";
    public int PROXY_PORT = 80;
    public boolean PROXY_AUTHENTICATION = false;
    public String PROXY_LOGIN = "";
    public String PROXY_PASSWORD_CRYPT = "";
    public boolean KEEP_PROXY_PASSWORD = false;
    private HTTPProxySettingsPanel myPanel;

    public static HttpConfigurable getInstance() {
        return ServiceManager.getService(HttpConfigurable.class);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = "";
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String proxyPassword = this.PROXY_PASSWORD_CRYPT;
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = "";
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.PROXY_PASSWORD_CRYPT = proxyPassword;
    }

    @Override
    public String getComponentName() {
        return "HttpConfigurable";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
    }

    public String getPlainProxyPassword() {
        return new String(new Base64().decode(this.PROXY_PASSWORD_CRYPT.getBytes()));
    }

    public void setPlainProxyPassword(String password) {
        this.PROXY_PASSWORD_CRYPT = new String(new Base64().encode(password.getBytes()));
    }

    public PasswordAuthentication getPromptedAuthentication(final String host, final String prompt) {
        if (this.PROXY_AUTHENTICATION && !this.KEEP_PROXY_PASSWORD) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AuthenticationDialog dlg = new AuthenticationDialog(host, prompt);
                    dlg.show();
                }
            };
            try {
                GuiUtils.runOrInvokeAndWait(runnable);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new PasswordAuthentication(this.PROXY_LOGIN, this.getPlainProxyPassword().toCharArray());
    }

    private Authenticator getAuthenticator() {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return HttpConfigurable.this.getPromptedAuthentication(this.getRequestingHost(), this.getRequestingPrompt());
            }
        };
    }

    public void prepareURL(String url) throws IOException {
        URLConnection connection;
        block3: {
            this.setAuthenticator();
            connection = new URL(url).openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.connect();
            try {
                connection.getInputStream();
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) break block3;
                throw (IOException)e;
            }
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public void setAuthenticator() {
        if (this.USE_HTTP_PROXY) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", this.PROXY_HOST);
            System.setProperty("http.proxyPort", Integer.toString(this.PROXY_PORT));
            Authenticator.setDefault(this.getAuthenticator());
        } else {
            System.setProperty("proxySet", "false");
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            Authenticator.setDefault(null);
        }
    }

    @Override
    public String getId() {
        return this.getHelpTopic();
    }

    @Override
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "HTTP Proxy";
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "http.proxy";
    }

    @Override
    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new HTTPProxySettingsPanel(HttpConfigurable.getInstance());
        }
        return this.myPanel.getComponent();
    }

    @Override
    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    @Override
    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    @Override
    public void disposeUIResources() {
        this.myPanel = null;
    }
}

