/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    public static final Key<Icon> LAST_FILE_ICON = Key.create((String)"lastVFileIcon");

    private IconUtil() {
    }

    public static Icon getIcon(VirtualFile file, int flags, Project project) {
        Icon lastIcon = (Icon)file.getUserData(LAST_FILE_ICON);
        return IconDeferrer.getInstance().defer(lastIcon != null ? lastIcon : file.getIcon(), new FileIconKey(file, project, flags), new Function<FileIconKey, Icon>(){

            public Icon fun(FileIconKey key) {
                VirtualFile file = key.getFile();
                int flags = key.getFlags();
                Project project = key.getProject();
                if (!file.isValid() || project != null && project.isDisposed()) {
                    return null;
                }
                Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
                Icon icon = providersIcon == null ? file.getIcon() : providersIcon;
                boolean dumb = project != null && DumbService.getInstance(project).isDumb();
                for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                    if (dumb && !(patcher instanceof DumbAware)) continue;
                    icon = patcher.patchIcon(icon, file, flags, project);
                }
                if ((flags & 2) != 0 && !file.isWritable()) {
                    icon = new LayeredIcon(icon, Icons.LOCKED_ICON);
                }
                file.putUserData(LAST_FILE_ICON, icon);
                return icon;
            }
        });
    }

    @Nullable
    private static Icon getProvidersIcon(VirtualFile file, int flags, Project project) {
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        return baseIcon;
    }

    @Nullable
    private static Icon createEmptyIconLike(String baseIconPath) {
        Icon baseIcon = IconLoader.findIcon((String)baseIconPath);
        if (baseIcon == null) {
            return new EmptyIcon(16, 16);
        }
        return new EmptyIcon(baseIcon.getIconWidth(), baseIcon.getIconHeight());
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.ourProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = (FileIconPatcher[])Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] ourProviders = (FileIconProvider[])Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }

    private static class FileIconKey {
        private final VirtualFile myFile;
        private final Project myProject;
        private final int myFlags;

        private FileIconKey(VirtualFile file, Project project, int flags) {
            this.myFile = file;
            this.myProject = project;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileIconKey)) {
                return false;
            }
            FileIconKey that = (FileIconKey)o;
            if (this.myFlags != that.myFlags) {
                return false;
            }
            if (!this.myFile.equals(that.myFile)) {
                return false;
            }
            return !(this.myProject != null ? !this.myProject.equals(that.myProject) : that.myProject != null);
        }

        public int hashCode() {
            int result = this.myFile.hashCode();
            result = 31 * result + (this.myProject != null ? this.myProject.hashCode() : 0);
            result = 31 * result + this.myFlags;
            return result;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public Project getProject() {
            return this.myProject;
        }

        public int getFlags() {
            return this.myFlags;
        }
    }
}

