/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.ReadWriteAccessUsage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTypeGroupingRule
implements UsageGroupingRule {
    @Override
    public UsageGroup groupUsage(Usage usage) {
        if (usage instanceof PsiElementUsage) {
            PsiElementUsage elementUsage = (PsiElementUsage)usage;
            UsageType usageType = UsageTypeGroupingRule.getUsageType(elementUsage.getElement());
            if (usageType != null) {
                return new UsageTypeGroup(usageType);
            }
            if (usage instanceof ReadWriteAccessUsage) {
                ReadWriteAccessUsage u = (ReadWriteAccessUsage)usage;
                if (u.isAccessedForWriting()) {
                    return new UsageTypeGroup(UsageType.WRITE);
                }
                if (u.isAccessedForReading()) {
                    return new UsageTypeGroup(UsageType.READ);
                }
            }
            return new UsageTypeGroup(UsageType.UNCLASSIFIED);
        }
        return null;
    }

    @Nullable
    private static UsageType getUsageType(PsiElement element) {
        UsageTypeProvider[] providers;
        if (element == null) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType(element, PsiComment.class, false) != null) {
            return UsageType.COMMENT_USAGE;
        }
        for (UsageTypeProvider provider : providers = (UsageTypeProvider[])Extensions.getExtensions(UsageTypeProvider.EP_NAME)) {
            UsageType usageType = provider.getUsageType(element);
            if (usageType == null) continue;
            return usageType;
        }
        return null;
    }

    private class UsageTypeGroup
    implements UsageGroup {
        private final UsageType myUsageType;

        private UsageTypeGroup(UsageType usageType) {
            if (usageType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/rules/UsageTypeGroupingRule$UsageTypeGroup.<init> must not be null");
            }
            this.myUsageType = usageType;
        }

        @Override
        public void update() {
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return null;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myUsageType.toString();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/UsageTypeGroupingRule$UsageTypeGroup.getText must not return null");
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void navigate(boolean focus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageTypeGroup)) {
                return false;
            }
            UsageTypeGroup usageTypeGroup = (UsageTypeGroup)o;
            return !(this.myUsageType != null ? !this.myUsageType.equals(usageTypeGroup.myUsageType) : usageTypeGroup.myUsageType != null);
        }

        public int hashCode() {
            return this.myUsageType != null ? this.myUsageType.hashCode() : 0;
        }
    }
}

