/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.ImportFilteringUsageViewSetting;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.ImportFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ImportUsageFilteringRuleProvider
implements UsageFilteringRuleProvider {
    @Override
    @NotNull
    public UsageFilteringRule[] getActiveRules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/ImportUsageFilteringRuleProvider.getActiveRules must not be null");
        }
        ArrayList<Object> rules = new ArrayList<Object>();
        if (!ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS) {
            rules.addAll(Arrays.asList(Extensions.getExtensions(ImportFilteringRule.EP_NAME)));
        }
        UsageFilteringRule[] usageFilteringRuleArray = rules.toArray(new UsageFilteringRule[rules.size()]);
        if (usageFilteringRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/ImportUsageFilteringRuleProvider.getActiveRules must not return null");
        }
        return usageFilteringRuleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public AnAction[] createFilteringActions(@NotNull UsageView view) {
        AnAction[] anActionArray;
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/ImportUsageFilteringRuleProvider.createFilteringActions must not be null");
        }
        UsageViewImpl impl = (UsageViewImpl)view;
        if (view.getPresentation().isCodeUsages()) {
            final JComponent component = view.getComponent();
            final ShowImportsAction showImportsAction = new ShowImportsAction(impl);
            showImportsAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(73, 128)), component);
            impl.scheduleDisposeOnClose(new Disposable(){

                public void dispose() {
                    showImportsAction.unregisterCustomShortcutSet(component);
                }
            });
            anActionArray = new AnAction[]{showImportsAction};
            if (anActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/usages/impl/ImportUsageFilteringRuleProvider.createFilteringActions must not return null");
            return anActionArray;
        }
        anActionArray = AnAction.EMPTY_ARRAY;
        if (AnAction.EMPTY_ARRAY != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/usages/impl/ImportUsageFilteringRuleProvider.createFilteringActions must not return null");
    }

    private static class ShowImportsAction
    extends RuleAction {
        private ShowImportsAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.show.import.statements", new Object[0]), IconLoader.getIcon((String)"/actions/showImportStatements.png"));
        }

        @Override
        protected boolean getOptionValue() {
            return ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS;
        }

        @Override
        protected void setOptionValue(boolean value) {
            ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS = value;
        }
    }
}

